<?php

use App\Http\Controllers\Backend\AppController;
use App\Http\Controllers\Backend\BlogCategoryController;
use App\Http\Controllers\Backend\BlogController;
use App\Http\Controllers\Backend\ComponentController as PageComponentController;
use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\Backend\DepositController;
use App\Http\Controllers\Backend\DepositMethodController;
use App\Http\Controllers\Backend\ItemController as PageComponentItemController;
use App\Http\Controllers\Backend\LanguageController;
use App\Http\Controllers\Backend\NavigationController;
use App\Http\Controllers\Backend\NotificationController;
use App\Http\Controllers\Backend\OrderController;
use App\Http\Controllers\Backend\PageController;
use App\Http\Controllers\Backend\PaymentGatewayController;
use App\Http\Controllers\Backend\PlanController;
use App\Http\Controllers\Backend\PluginController;
use App\Http\Controllers\Backend\ProfileController;
use App\Http\Controllers\Backend\RoleController;
use App\Http\Controllers\Backend\SeoController;
use App\Http\Controllers\Backend\ServicesController;
use App\Http\Controllers\Backend\SettingController;
use App\Http\Controllers\Backend\SiteCustomController;
use App\Http\Controllers\Backend\SocialController;
use App\Http\Controllers\Backend\StaffController;
use App\Http\Controllers\Backend\SubscriberController;
use App\Http\Controllers\Backend\SubscriptionController;
use App\Http\Controllers\Backend\SupportCategoryController;
use App\Http\Controllers\Backend\TaskController;
use App\Http\Controllers\Backend\ThemeController;
use App\Http\Controllers\Backend\TicketController;
use App\Http\Controllers\Backend\TransactionController;
use App\Http\Controllers\Backend\UserController;

/*
|--------------------------------------------------------------------------
| Backend Routes
|--------------------------------------------------------------------------
| Backend routes accessible to authenticated admins with 2FA.
| Routes are prefixed with the admin prefix set in the settings.
|
*/

Broadcast::routes(['middleware' => ['auth:web,admin']]);
Route::group(['prefix' => setting('admin_prefix'), 'as' => 'admin.'], function () {

    // Dashboard Route
    Route::get('/', [DashboardController::class, 'dashboard'])->name('dashboard');

    // Profile Management
    Route::controller(ProfileController::class)->prefix('profile')->as('profile.')->group(function () {
        Route::get('/', 'profile')->name('settings');
        Route::post('/update', 'update')->name('update');
        Route::get('/2fa-generate', 'twoFaAuthGenerate')->name('2fa-generate');
        Route::post('/2fa', 'twoFaAuth')->name('2fa-auth');
        Route::post('/2fa-verify', 'twoFaAuthVerify')->name('2fa-verify');
        Route::post('/password-update', 'passwordUpdate')->name('password-update');
    });

    //Users Manage Routes
    Route::controller(UserController::class)->prefix('users')->as('users.')->group(function () {
        // GET Routes
        Route::get('all', 'all')->name('all');  // All users
        Route::get('active', 'active')->name('active');  // Active users
        Route::get('banned', 'banned')->name('banned');  // Banned users
        Route::get('unverified', 'unverified')->name('unverified');  // Unverified users
        Route::get('manage/{id}', 'manage')->name('manage');  // Manage specific user
        Route::get('login/{id}', 'login')->name('login');  // User login
        Route::get('edit/{id}', 'edit')->name('edit');  // Edit user info
        Route::get('transaction/{id}', 'transaction')->name('transaction');  // User transaction history
        Route::get('send-notification', 'sendNotification')->name('send-notification');  // Send notification to user

        // POST Routes
        Route::post('balance-update', 'balanceUpdate')->name('balance-update');  // Update user balance
        Route::post('status-update', 'statusUpdate')->name('status-update');  // Update user status
        Route::post('notify', 'notify')->name('notify');  // Send notifications
        Route::post('password-change/{id}', 'passwordChange')->name('password-change');  // Change user password

        // PUT Routes
        Route::put('info-update/{id}', 'infoUpdate')->name('info-update');  // Update user information
    });


    //Staff Manage Routes
    Route::resource('staff', StaffController::class)->except(['show', 'create', 'destroy']);
    Route::resource('role', RoleController::class);

    /***************************************************************************
     * Payment Gateways and Deposit Management
     ***************************************************************************/

    // Payment Gateway Management
    Route::group(['prefix' => 'payment', 'as' => 'payment.'], function () {
        Route::resource('gateway', PaymentGatewayController::class)->only(['index', 'edit', 'update']);
        Route::get('gateway-currency/{gateway_id}', [PaymentGatewayController::class, 'gatewayCurrency'])->name('gateway-currency');
    });

    // Deposit Management
    Route::prefix('deposit')->as('deposit.')->group(function () {
        Route::resource('method', DepositMethodController::class)->except('show', 'index');
        Route::get('method/{type}', [DepositMethodController::class, 'method'])->name('method.type');
        Route::controller(DepositController::class)->group(function () {
            Route::get('history', 'history')->name('history');
            Route::get('manual-request', 'manualDepositRequest')->name('manual-request');
            Route::match(['get', 'post'], 'deposit-request-action/{id}', 'depositRequestAction')->name('deposit-request-action');
        });
    });

    // Transaction Management
    Route::get('transaction', [TransactionController::class, 'transaction'])->name('transaction');

    /***************************************************************************
     * Orders and Tasks Management
     ***************************************************************************/

    Route::prefix('order')->as('order.')->controller(OrderController::class)->group(function () {
        Route::resource('task', TaskController::class)->only(['store', 'edit', 'update', 'destroy']);
        Route::get('manual-payment', 'manualPayment')->name('manual-payment');
        Route::get('request', 'orderRequest')->name('request');
        Route::get('manage/{id}', 'orderManage')->name('manage');
        Route::patch('status-update/{order}', 'updateStatus')->name('status-update');
        Route::get('working', 'working')->name('working');
        Route::get('history', 'history')->name('history');
        Route::post('task-status-update', [TaskController::class, 'statusUpdate'])->name('task.status-update');
        Route::get('task-show/{id}', [TaskController::class, 'taskShow'])->name('task.show');
        Route::get('task-file/{task_id}', [TaskController::class, 'taskFile'])->name('task-file');
    });

    // Subscription Management
    Route::prefix('subscription')->as('subscription.')->controller(SubscriptionController::class)->group(function () {
        Route::get('manual-payment', 'manualPayment')->name('manual-payment');
        Route::get('running', 'running')->name('running');
        Route::get('expired', 'expired')->name('expired');
        Route::get('history', 'history')->name('history');
    });

    /***************************************************************************
     * Plans, Services
     ***************************************************************************/

    Route::resource('service', ServicesController::class)->except('show');
    Route::resource('plan', PlanController::class)->except('show', 'create');

    /***************************************************************************
     * Site Management: Settings, Plugins, Languages, Navigation, Pages, SEO
     ***************************************************************************/

    Route::prefix('settings')->as('settings.')->group(function () {
        Route::resource('site', SettingController::class)->only(['index', 'update']);
        Route::resource('plugin', PluginController::class)->only(['index', 'edit', 'update']);
        Route::get('{plugin_type}', [PluginController::class, 'pluginType'])->name('plugin_type');
    });

    // Language Management
    Route::prefix('language')->as('language.')->group(function () {
        Route::get('translate/{code}', [LanguageController::class, 'translate'])->name('translate');
        Route::post('translate-update', [LanguageController::class, 'translatedUpdate'])->name('translate-update');
        Route::get('sync-missing-keys', [LanguageController::class, 'syncMissingKeys'])->name('sync-missing-keys');
    });
    Route::resource('language', LanguageController::class);

    // Navigation and Page Management
    Route::prefix('navigation')->as('navigation.')->group(function () {
        Route::resource('site', NavigationController::class)->except(['create', 'show']);
        Route::controller(NavigationController::class)->group(function () {
            Route::post('position-update', 'positionUpdate')->name('position-update');
            Route::delete('position-remove', 'positionRemove')->name('position-remove');
            Route::get('{type}', 'type')->name('type');
        });
    });

    Route::prefix('page')->as('page.')->group(function () {
        Route::resource('site', PageController::class)->except('show');
        Route::resource('component', PageComponentController::class)->except('show');
        Route::resource('component-item', PageComponentItemController::class)->except(['index', 'show']);
        Route::get('component-filter', [PageComponentController::class, 'componentFilter'])->name('component-filter');
        Route::get('{setting_type}', [PageController::class, 'settingType'])->name('setting-type');
    });

    // SEO Management
    Route::get('SEO-Manage', [SeoController::class, 'index'])->name('seo');

    /***************************************************************************
     * Blog Management
     ***************************************************************************/

    Route::prefix('blog')->as('blog.')->group(function () {
        Route::resource('site', BlogController::class)->except('show');
        Route::resource('category', BlogCategoryController::class)->except(['show', 'create']);
    });

    /***************************************************************************
     * Theme and Social Media Management
     ***************************************************************************/

    Route::prefix('theme')->as('theme.')->controller(ThemeController::class)->group(function () {
        Route::get('/', 'index')->name('index');
        Route::post('update', 'update')->name('update');
    });

    Route::resource('social', SocialController::class)->except(['create', 'show']);


    Route::prefix('support-ticket')->as('support-ticket.')->controller(TicketController::class)->group(function () {
        Route::resource('category', SupportCategoryController::class)->except(['show', 'create']);
        Route::get('pending', 'pendingTicket')->name('new');
        Route::get('inprogress', 'inprogress')->name('inprogress');
        Route::get('close', 'closeTicket')->name('close');
        Route::get('history', 'history')->name('history');
        Route::get('show/{ticket}', 'ticketShow')->name('show');
        Route::post('reply/{ticket}', 'ticketReplyStore')->name('reply');
        Route::put('status-update/{ticket_id}', 'statusUpdate')->name('status-update');
    });

    // Notification Management Routes
    Route::controller(NotificationController::class)->prefix('notifications')->as('notifications.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('recent', 'recent')->name('recent');
        Route::get('{id}/read', 'markAsRead')->name('markAsRead');
        Route::get('read-all', 'markAllAsRead')->name('read-all');

        Route::get('template', 'template')->name('template');
        Route::get('push-template/{id}', 'pushTemplate')->name('push-template-manage');
        Route::get('mail-template/{id}', 'mailTemplate')->name('mail-template-manage');
        Route::post('push-template', 'pushTemplateUpdate')->name('push-template');
        Route::post('mail-template', 'mailTemplateUpdate')->name('mail-template');
    });

    /***************************************************************************
     * Other Routes: Subscriptions, Custom CSS/JS, App Settings
     ***************************************************************************/

    // Subscriber Management
    Route::controller(SubscriberController::class)->group(function () {
        Route::get('subscriber', 'subscription')->name('subscriber');
        Route::post('mail-send', 'mailSend')->name('mail-send');
    });

    // Custom CSS/JS
    Route::controller(SiteCustomController::class)->prefix('custom')->as('custom.')->group(function () {
        Route::get('{type}', 'type')->name('type');
        Route::post('update', 'update')->name('update.type');
    });

    // App Settings and Optimization
    Route::controller(AppController::class)->group(function () {
        Route::get('app', 'app')->name('app');
        Route::get('optimize', 'optimize')->name('optimize');
        Route::get('clear-cache', 'clearCache')->name('clear-cache');
        Route::get('smtp-connection-check', 'smtpConnectionCheck')->name('smtp-connection-check');
        Route::get('download-file', 'downloadFile')->name('download-file');
    });
});
