@php
    $pusherConfig = pluginCredentials('pusher');
@endphp

@if($pusherConfig['status'] == \App\Constants\Status::TRUE)
{{--    <script src="{{ asset('general/js/pusher.min.js') }}"></script>--}}
<script src="https://js.pusher.com/7.0/pusher.min.js"></script>

    <script>
        (function () {
            'use strict';

            const pusherKey = '{{ $pusherConfig['pusher_app_key'] }}';
            const pusherCluster = '{{ $pusherConfig['pusher_app_cluster'] }}';
            const authEndpoint = '/broadcasting/auth';

            // Ensure CSRF token is available
            const csrfToken = $('meta[name="csrf-token"]').attr('content');
            if (!csrfToken) {
                console.error('CSRF token not found!');
                return;
            }

            // Initialize Pusher
            const pusher = new Pusher(pusherKey, {
                cluster: pusherCluster,
                encrypted: true,
                authEndpoint: authEndpoint,
                auth: {
                    headers: {
                        'X-CSRF-TOKEN': csrfToken
                    }
                }
            });


            pusher.logToConsole = true;



            let userId, isAdmin, channelName;

            @if (auth('admin')->check())
                    isAdmin = true;
                    userId = {{ auth('admin')->user()->id }};
                    channelName = `private-App.Models.Admin.${userId}`;
                @elseif (auth()->check())
                    isAdmin = false;
                    userId = {{ auth()->user()->id }};
                    channelName = `private-App.Models.User.${userId}`;
                @else
                     console.error('No user authenticated.');
                return;
            @endif
            // Helper to subscribe to a channel and bind notification event
            const subscribeToChannel = (channelName, callback) => {

                const channel = pusher.subscribe(channelName);

                channel.bind('Illuminate\\Notifications\\Events\\BroadcastNotificationCreated', function (data) {
                    console.log(data);
                    if (typeof callback === 'function') callback(data);
                });
            };

            // Subscribe to user/admin-specific channel and fetch notifications
            subscribeToChannel(channelName, function (data) {
                const $notificationDropdown = isAdmin
                    ? $('#append-new-admin-notification')
                    : $('#append-new-notification');

                const notificationUrl = isAdmin
                    ? '{{ route('admin.notifications.recent') }}'
                    : '{{ route('user.notifications.recent') }}';

                $.get(notificationUrl, function (response) {
                    $notificationDropdown.html(response); // Update notifications
                });
            });

        })();
    </script>
@endif
