@extends('frontend.layouts.user.app')
@section('title', __('Transaction'))
@section('user-content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="d-flex flex-wrap justify-content-end mb-3">
                <form action="{{ route('user.transaction') }}" class="d-flex flex-wrap align-items-center">
                    {{-- Status Filter Dropdown --}}
                    <div class="me-2 mb-2 mb-md-0">
                        <select class="form-select" name="status" aria-label="Filter by Status">
                            <option value="all" selected>{{ __('All') }}</option>
                            @foreach(\App\Constants\TxnStatus::STATUS as $key => $value)
                                <option value="{{ $value }}" @selected(request('status') == $value)>{{ ucwords($value) }}</option>
                            @endforeach
                        </select>
                    </div>
                    {{-- Search Input --}}
                    <div class="me-2 mb-2 mb-md-0">
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                               placeholder="{{ __('Search...') }}" aria-label="{{ __('Search ...') }}">
                    </div>
                    {{-- Search Button --}}
                    <button type="submit" class="btn btn-primary mb-2 mb-md-0">
                        <x-svg i="search"/>
                        <span class="ms-1">{{ __('Search') }}</span>
                    </button>
                </form>
            </div>

            <div class="table-responsive  rounded mb-3">
                <table class="table card-table  table-vcenter text-nowrap mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Description') .' | ' . __('TXN ID') }}</th>
                        <th>{{ __('Method') .' | ' . __('Method Type') }}</th>
                        <th>{{ __('Amount') .' | ' . __('Type') }}</th>
                        <th>{{ __('Fee') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Time') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($transactions as $transaction)
                        @php
                            // Define the status color map
                            $statusColors = [
                                \App\Constants\TxnStatus::PENDING => 'blue',
                                \App\Constants\TxnStatus::COMPLETED => 'green',
                                \App\Constants\TxnStatus::FAILED => 'red'
                            ];

                            // Get the color from the status, fallback to 'blue'
                            $color = $statusColors[$transaction->status] ?? 'blue';

                            // Define the prefix based on transaction type and status
                            $prefix = null;
                            if ($transaction->status == \App\Constants\TxnStatus::COMPLETED) {
                                $prefix = match ($transaction->type) {
                                    \App\Constants\TxnType::DEPOSIT,\App\Constants\TxnType::ADD_BALANCE => '+',
                                    \App\Constants\TxnType::SUBTRACT_BALANCE => '-',
                                    default => null,
                                };
                            }

                            // Cache repeated attribute calls
                            $txid = ucwords($transaction->txid);
                            $methodType = ucwords($transaction->method_type);
                            $transactionType = title($transaction->type);
                            $transactionAmount = $prefix . $transaction->amount . ' ' . $transaction->currency;
                            $fee = $transaction->fee . ' ' . $transaction->currency;
                            $statusText = strtoupper($transaction->status);
                            $createdAtTime = $transaction->created_at_time;
                            $createdAtDiff = $transaction->created_at->diffForHumans();
                        @endphp

                        <tr class="align-middle">
                            <td data-bs-toggle="tooltip" data-bs-placement="top" title="{{ $transaction->action_cause }}">
                                <div>{{ $transaction->description }}</div>
                                <div class="text-secondary">{{ $txid }}</div>
                            </td>
                            <td>
                                {{ $transaction->method }}
                                <div class="text-secondary">{{ $methodType }}</div>
                            </td>
                            <td>
                                <div class="text-{{ $prefix == '-' ? 'red' : $color }}">
                                    {{ $transactionAmount }}
                                </div>
                                <div class="text-secondary">{{ $transactionType }}</div>
                            </td>
                            <td>
                                {{ $fee }}
                            </td>
                            <td>
                                <span class="badge bg-{{ $color }} text-{{ $color }}-fg">{{ $statusText }}</span>
                            </td>
                            <td>
                                <div>{{ $createdAtTime }}</div>
                                <div class="text-secondary">{{ $createdAtDiff }}</div>
                            </td>
                        </tr>
                    @endforeach

                    </tbody>
                </table>
            </div>
            {{-- Pagination at the end --}}
            <div class="mt-3 d-flex justify-content-end">
                {{ $transactions->links() }}
            </div>

            @if(!$transactions->count())
                <h4 class="text-center text-muted">{{ __('No data found') }}</h4>
            @endif
        </div>
    </div>

@endsection




