@extends('frontend.layouts.user.app')
@section('title', __('Support Ticket Details'))
@section('page-actions')
    <div class="col-auto ms-auto d-print-none">
        <div class="btn-list">
            <a href="{{ route('user.support-ticket.index') }}" class="btn btn-primary">
                <x-icon name="chat-4" class="icon"/>
                {{ __('My Ticket ') }}
            </a>
        </div>
    </div>
@endsection
@section('user-content')
    <div class="card">
        <div class="row g-0">
            <div class="col-12 d-flex flex-column">
                {{-- Card Header --}}
                <div class="card-header">
                    <div class="row">
                        <div class="col">
                            <h3 class="card-title mb-1">{{ $ticket->title }}</h3>
                        </div>
                    </div>
                </div>

                {{-- Card Body --}}
                <div class="card-body overflow-auto" style="max-height: 400px;">
                    <div class="chat">
                        <div class="chat-bubbles">
                            {{-- First Ticket Message --}}
                            <div class="chat-item">
                                <div class="row align-items-end justify-content-end">
                                    <div class="col-lg-6">
                                        <div class="chat-bubble chat-bubble-me">
                                            <div class="chat-bubble-title">
                                                <div class="row">
                                                    <div class="col">
                                                        <span class="chat-bubble-author">{{ __('Me') }}</span>
                                                    </div>
                                                    <div class="col-auto">
                                                        <span class="chat-bubble-date">{{ $ticket->created_at->diffForHumans() }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="chat-bubble-body">
                                                <p>{{ $ticket->message }}</p>
                                                @if($ticket->attachment)
                                                    <a href="{{ route('admin.download-file',['file' => $ticket->attachment]) }}" class="d-block mt-2 text-decoration-none text-teal small" target="_blank">
                                                        <i class="fa-solid fa-download"></i> {{ __('Download Attachment') }}
                                                    </a>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    @include('frontend.user.ticket.partial._avatar', ['avatar' => $ticket->user->avatar])
                                </div>
                            </div>

                            {{-- Ticket Replies --}}
                            @foreach($ticket->messages as $message)
                                <div class="chat-item">
                                    <div class="row align-items-end {{ $message->admin_id !== null ? '' : 'justify-content-end' }}">
                                        @if($message->admin_id !== null)
                                            @include('frontend.user.ticket.partial._avatar', ['avatar' => $message->admin->avatar])
                                        @endif
                                        <div class="col-lg-6">
                                            <div class="chat-bubble {{ $message->admin_id == null ? 'chat-bubble-me' : '' }}">
                                                <div class="chat-bubble-title">
                                                    <div class="row">

                                                        <div class="col">
                                                            <span class="chat-bubble-author">{{ $message->admin_id == null ? __('Me') : $message->admin->name }}</span>
                                                        </div>
                                                        <div class="col-auto">
                                                            <span class="chat-bubble-date">{{ $message->created_at->diffForHumans() }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="chat-bubble-body">
                                                    <p>{{ $message->message }}</p>
                                                    @if($message->attachment)
                                                        <a href="{{ route('admin.download-file',['file' => $message->attachment]) }}" class="d-block mt-2 text-decoration-none text-teal small" target="_blank">
                                                            <i class="fa-solid fa-download"></i> {{ __('Download Attachment') }}
                                                        </a>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        @if($message->admin_id == null)
                                            @include('frontend.user.ticket.partial._avatar', ['avatar' => $ticket->user->avatar])
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Card Footer (Chat Input) --}}
                <div class="card-footer chat-input bg-light border-top-0 p-3">
                    <form action="{{ route('user.support-ticket.reply', $ticket->id) }}" method="POST" enctype="multipart/form-data" class="row g-3">
                        @csrf

                        {{-- File Attachment Input --}}
                        <div class="col-12 col-sm-auto">
                            <label for="file-input" class="btn btn-primary d-flex align-items-center w-100 w-sm-auto">
                                <i class="fa-regular fa-paperclip me-2"></i> {{ __('Attachment') }}
                            </label>
                            <input type="file" id="file-input" name="attachment" class="d-none" aria-label="Upload" onchange="showFileName(this)">
                        </div>

                        {{-- Attachment Preview --}}
                        <div class="col-12 col-sm-auto d-none" id="attachment-preview">
                            <span class="badge bg-secondary p-2" id="file-name">No file selected</span>
                        </div>

                        {{-- Message Text Area --}}
                        <div class="col-12 col-sm flex-grow-1">
                            <textarea name="message" id="message-textarea" class="form-control" rows="1" placeholder="Type your message here..." required></textarea>
                        </div>

                        {{-- Send Button --}}
                        <div class="col-12 col-sm-auto">
                            <button class="btn btn-primary d-flex align-items-center w-100 w-sm-auto" type="submit">
                                <i class="fa-regular fa-paper-plane-top"></i>
                                <span class="mx-2">{{ __('Send Reply') }}</span>
                            </button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
@endsection
@push('user-script')
    <script>
        function showFileName(input) {
            var fileName = input.files[0].name;
            document.getElementById('file-name').innerText = fileName;
            document.getElementById('attachment-preview').classList.remove('d-none');
        }

        // Adjust textarea rows based on screen size
        function adjustTextareaRows() {
            const textarea = document.getElementById('message-textarea');
            if (window.innerWidth <= 576) {
                textarea.setAttribute('rows', '2');
            } else {
                textarea.setAttribute('rows', '1');
            }
        }

        // Run adjustTextareaRows on page load and window resize
        window.addEventListener('load', adjustTextareaRows);
        window.addEventListener('resize', adjustTextareaRows);
    </script>

@endpush
