@extends('frontend.layouts.user.app')
@section('title', __('Support Ticket'))
@section('page-actions')
    <div class="col-auto ms-auto d-print-none">
        <div class="btn-list">
            <a href="{{ route('user.support-ticket.create') }}" class="btn btn-primary">
                <x-svg i="ticket" class="icon"/>
                {{ __('New Support Ticket') }}
            </a>
        </div>
    </div>
@endsection
@section('user-content')
    <div class="row g-4">
        <div class="col-md-12">
            <div class="row row-cards">
                <div class="space-y">
                    @foreach($tickets as $ticket)

                        @php
                            $statusColor = ['pending' => 'info','in_progress' => 'tertiary', 'completed' => 'success', 'closed' => 'danger' ][$ticket->status];
                            $priorityColor = ['low' => 'info', 'medium' => 'warning', 'high' => 'danger'][$ticket->priority] ?? 'blue';

                        @endphp
                        <div class="card">
                            <div class="row g-0">
                                <div class="col-auto">
                                    <div class="card-body">
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="card-body ps-0">
                                        <div class="row">
                                            <div class="col">
                                                <h3 class="mb-0"><a
                                                            href="{{ route('user.support-ticket.show', $ticket->id) }}">{{ $ticket->title }}</a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md">
                                                <div class="mt-3 list-inline list-inline-dots mb-0 text-secondary d-sm-block d-none">
                                                    <a class="list-inline-item"
                                                       href="{{ route('user.support-ticket.show', $ticket->id) }}">
                                                        <i class="fa-regular fa-ticket"></i>
                                                        {{ $ticket->uuid }}
                                                    </a>
                                                    <div class="list-inline-item">
                                                        <i class="fa-solid fa-timer"></i>
                                                        {{ $ticket->created_at->diffForHumans() }}
                                                    </div>
                                                    @if($ticket->isReplied())
                                                        <div class="list-inline-item">
                                                        <span class="badge bg-teal text-white">
                                                            <i class="fa-solid fa-messages"></i>
                                                            {{ __('Answered') }}
                                                        </span>
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="mt-3 list mb-0 text-secondary d-block d-sm-none">

                                                    <a class="list-item"
                                                       href="{{ route('user.support-ticket.show', $ticket->id) }}">
                                                        <i class="fa-regular fa-ticket"></i>
                                                        {{ $ticket->uuid }}
                                                    </a>
                                                    <div class="list-item">
                                                        <i class="fa-solid fa-timer"></i>
                                                        {{ $ticket->created_at->diffForHumans() }}
                                                    </div>
                                                    @if($ticket->isReplied())
                                                        <div class="list-item">
                                                        <span class="badge bg-teal text-white">
                                                            <i class="fa-solid fa-messages"></i>
                                                            {{ __('Answered') }}
                                                        </span>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-auto">
                                                <div class="mt-3 badges">

                                                    <div class="badge badge-outline text-secondary fw-normal badge-pill">
                                                        <i class="fa-solid fa-layer-group"></i>
                                                        {{ $ticket->category->name ?? __('UnCategorized') }}
                                                    </div>
                                                    <div class="badge bg-{{ $priorityColor }} text-white fw-normal badge-pill">
                                                        <i class="fa-solid fa-wave-pulse"></i>
                                                        {{ $ticket->priority }}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ribbon bg-{{ $statusColor }}">
                                        {{ title($ticket->status) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="mt-3 d-flex justify-content-end">
                    {{ $tickets->links() }}
                </div>
            </div>
        </div>
    </div>


    @if(!$tickets->count())
        <div class="card text-center">
            <div class="card-body">
                <h4 class="card-title text-muted">{{ __('No tickets found') }}</h4>
            </div>
        </div>
    @endif
@endsection




