@extends('frontend.layouts.user.app')
@section('title', __('New Support Ticket'))
@section('page-actions')
    <div class="col-auto ms-auto d-print-none">
        <div class="btn-list">
            <a href="{{ route('user.support-ticket.index') }}" class="btn btn-primary">
                <x-icon name="chat-4" class="icon" />
                {{ __('My Ticket') }}
            </a>
        </div>
    </div>
@endsection
@section('user-content')

    <div class="card">
        <div class="card-body">
            <form action="{{ route('user.support-ticket.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="title" class="form-label">{{ __('Ticket Title') }}</label>
                            <input type="text"
                                   class="form-control @error('title') is-invalid @enderror"
                                   id="title"
                                   name="title"
                                   value="{{ old('title') }}"
                                   required>
                            @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="category_id" class="form-label">{{ __('Category (Optional)') }}</label>
                            <select class="form-select @error('category_id') is-invalid @enderror"
                                    id="category_id"
                                    name="category_id"
                                    required>
                                <option value="">{{ __('Select Category') }}</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}"
                                            {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                        {{ ucfirst($category->name) }}
                                    </option>
                                @endforeach
                            </select>
                            @error('category_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="message" class="form-label">{{ __('Message') }}</label>
                    <textarea class="form-control @error('message') is-invalid @enderror"
                              id="message"
                              name="message"
                              rows="5"
                              required>{{ old('message') }}</textarea>
                    @error('message')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="attachments" class="form-label">{{ __('Attach Files (Optional)') }}</label>
                            <input type="file"
                                   class="form-control @error('attachments') is-invalid @enderror"
                                   id="attachments"
                                   name="attachment"
                                   multiple>
                            @error('attachments')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="priority" class="form-label">{{ __('Priority') }}</label>
                            <select class="form-select @error('priority') is-invalid @enderror"
                                    id="priority"
                                    name="priority"
                                    required>
                                <option value="low">{{ __('Low') }}</option>
                                <option value="medium">{{ __('Medium') }}</option>
                                <option value="high">{{ __('High') }}</option>
                            </select>
                            @error('priority')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="mt-3">
                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary">
                            <x-svg i="message-share" /> {{ __('Submit Support Ticket') }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection



