<script>
    $(document).ready(function () {
        'use strict';

        // Store the plans data
        let plans = @json($plans);

        // Cache jQuery selectors
        const $planSelect = $('#plan-select');
        const $planTypeSelect = $('#plan-type-select');
        const $planNamePreview = $('#plan-name-preview');
        const $planTypePreview = $('#plan-type-preview');
        const $planPricePreview = $('#plan-price-preview');

        // Store the currency symbol
        const currencySymbol = `{{ setting('currency_symbol') }}`;

        // Function to update the preview
        function updatePlanPreview() {
            let selectedPlanId = $planSelect.val();
            let selectedPlan = plans.find(item => item.id == selectedPlanId);

            if (selectedPlan) {
                let planType = $planTypeSelect.val();
                let price = planType === '{{ \App\Constants\PlanType::MONTHLY }}' ? selectedPlan.monthly_price : selectedPlan.yearly_price;

                // Update the HTML elements
                $planNamePreview.html(selectedPlan.name.en.charAt(0).toUpperCase() + selectedPlan.name.en.slice(1));
                $planTypePreview.html(planType.charAt(0).toUpperCase() + planType.slice(1));
                $planPricePreview.html(currencySymbol + price);
            }
        }

        // Event listeners for plan select and type select
        $planSelect.on('change', updatePlanPreview);
        $planTypeSelect.on('change', updatePlanPreview);

        // Initial update
        updatePlanPreview();
    });

</script>
