<div class="col-lg-8">
    <form class="card" method="get" action="{{ route('user.subscription.request') }}">
        <div class="progress d-none" id="progress-bar">
            <div class="progress-bar progress-bar-indeterminate bg-green"></div>
        </div>
        <div class="card-body">
            <h3 class="card-title text-primary mb-4">{{ __('Plan Information') }}</h3>
            <div class="row g-4">
                {{-- Deposit Method Selection --}}
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label" for="plan-select">{{ __('Plan') }}</label>
                        <select class="form-select" name="plan_id"  id="plan-select" aria-label="{{ __('Plan') }}" required aria-describedby="plan-hint">
                            <option value="0" disabled selected>{{ __('Select Plan') }}</option>
                            @foreach($plans as $plan)
                                <option value="{{ $plan->id }}" {{ old('plan_id') == $plan->id ? 'selected' : '' }} >{{ _tr($plan->name) }}</option>
                            @endforeach
                        </select>
                        <small class="form-hint text-danger">{{ __('Current Plan').' : '._tr($currentPlan->name) }}</small>
                    </div>
                </div>

                {{-- Amount Input --}}
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label" for="plan-select">{{ __('Plan Duration') }}</label>
                        <select class="form-select" name="plan_type"  id="plan-type-select" aria-label="{{ __('Plan') }}" required aria-describedby="plan-hint">
                            @foreach(\App\Constants\PlanType::TYPE as $key => $type)
                                <option value="{{ $type }}" {{ old('plan_id') == $type ? 'selected' : '' }} >{{ title($type) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

        </div>

        {{-- Submit Button --}}
        <div class="card-footer text-end">
            <button type="submit" class="btn btn-primary"> <x-svg i="right-arrow"/> {{ __('Process To Upgrade') }}</button>
        </div>
    </form>
</div>
