<div class="col-lg-8">
    <form class="card" method="POST" action="{{ route('user.subscription.store') }}" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="txn_type" value="{{ $txnType ?? \App\Constants\TxnType::SUBSCRIPTION }}">
        <input type="hidden" name="plan_id" value="{{ $subscriptionInfo['plan_id'] }}">
        <input type="hidden" name="plan_type" value="{{ $subscriptionInfo['plan_type'] }}">
        <div class="progress d-none" id="progress-bar">
            <div class="progress-bar progress-bar-indeterminate bg-green"></div>
        </div>
        <div class="card-body">
            <h3 class="card-title text-primary mb-4">{{ __('Payment Information') }}</h3>
            <div class="row g-4">
                {{-- Deposit Method Selection --}}
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label" for="deposit-method-select">{{ __('Payment Method') }}</label>
                        <select class="form-select" name="deposit_method"  id="deposit-method-select" aria-label="{{ __('Payment Method') }}" required aria-describedby="deposit-method-hint">
                            <option value="0" disabled selected>{{ __('Select Payment Method') }}</option>
                            <option value="user_balance" >{{ __('User Balance:') }} {{ \App\Facades\BalanceFacade::get(Auth::user()) }} {{ setting('site_currency') }}</option>
                            @foreach($depositMethods as $depositMethod)
                                <option value="{{ $depositMethod->id }}" {{ old('payment_method') == $depositMethod->id ? 'selected' : '' }} >{{ $depositMethod->name }}</option>
                            @endforeach
                        </select>
                        <small id="deposit-method-hint" class="form-hint text-muted">{{ __('Choose your preferred method of payment.') }}</small>
                        <small class="form-hint text-danger" id="charge"></small>
                    </div>
                </div>

                {{-- Amount Input --}}
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label" for="deposit-amount">{{ __('Amount') }}</label>
                        <div class="input-group">
                            <input type="text" name="amount" value="{{ $subscriptionInfo['plan_price'] }}" id="deposit-amount" disabled class="form-control"  aria-describedby="amount-hint"  autocomplete="off">
                            <span class="input-group-text">{{ setting('site_currency') }}</span>
                        </div>
                        <small id="amount-hint" class="form-hint text-muted">{{ __('This amount will be deducted from your account') }}</small>
                        <small class="form-hint text-danger" id="amount-limit"></small>
                    </div>
                </div>
            </div>

            <div class="row g-1" id="manual-deposit-info">

            </div>

            <div class="row g-4" id="manual-deposit-row">

            </div>
        </div>

        {{-- Submit Button --}}
        <div class="card-footer text-end">
            <button type="submit" class="btn btn-primary"> <x-svg i="right-arrow"/> {{ __('Process To Pay') }}</button>
        </div>
    </form>
</div>
