@extends('frontend.layouts.user.app')
@section('title', __('My Subscription'))
@section('user-content')
    <div class="card">
        <div class="card-body">
            @if($subscription)
                <div class="row g-2 align-items-center">
                    <div class="col-auto">
                    <span class="avatar avatar-lg bg-secondary"
                          style="background-image: url({{ asset($subscription->plan->icon) }})"></span>
                    </div>
                    <div class="col">
                        <h4 class="card-title m-0">
                            {{ __('Plan Name: ') }} {{ _tr($subscription->plan->name) }}
                        </h4>
                        <div class="text-secondary">
                            @if($subscription->transaction->status !== \App\Constants\TxnStatus::COMPLETED)
                                <span class="badge bg-warning text-warning-fg"> {{ __('Payment Pending') }} </span>
                            @elseif($subscription->isExpired())
                                <span class="badge bg-red text-red-fg"> {{ __('Expired') }} </span>
                            @else
                                {{ __('Expiry On:') }} <span
                                        class="badge bg-green text-green-fg">{{ $subscription->expiry_date->format('d M, Y') }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="col-auto">
                        @if($subscription->isAvailableForRenew())
                            <a href="{{ route('user.subscription.renew') }}"
                               class="btn btn-warning  d-inline-flex align-items-center">
                                <x-icon name="repeat"/> {{ __('Renew') }}
                            </a>
                        @endif
                        <a href="{{ route('user.subscription.upgrade') }}"
                           class="btn btn-primary  d-inline-flex align-items-center">
                            <x-icon name="upgrade"/> {{ __('Upgrade') }}
                        </a>
                    </div>
                </div>
            @else
                <div class="text-center">
                    <h4 class="card-title m-0">
                        {{ __('No Subscription Found') }}
                    </h4>
                </div>
            @endif
        </div>
    </div>
@endsection




