@extends('frontend.user.setting.index')
@section('title', __('Security Settings'))
@section('user-setting-content')
    <div class="card card-body border-0 shadow mb-4">
        <h2 class="mb-4">🔒 {{ __('Two Factor Authentication (2FA)') }}</h2>
        @if(null !== $user->google2fa_secret)
            <p>{{ __('Two Factor Authentication (2FA) strengthens access security by requiring two methods to verify your identity. It protects against phishing, social engineering, and password brute force attacks.') }}</p>

            @if($user->google2fa_enabled == \App\Constants\Status::ACTIVE)
                <p>{{ __('Two Factor Authentication (2FA) is currently enabled.') }}</p>
                <span class="text-muted pb-2">{{ __('Enter Your Login Password') }}</span>
            @else
                {!! app('pragmarx.google2fa')->getQRCodeInline(config('app.name'), $user->email, $user->google2fa_secret) !!}
                <p>{{ __('Scan the QR code with your Google Authenticator App') }}</p>
                <span class="text-muted pb-2">{{ __('Enter the PIN from Google Authenticator App') }}</span>
            @endif

            <form action="{{ route('user.profile.2fa-auth') }}" method="POST">
                @csrf

                <div class="form-group">
                    <input type="password" name="one_time_password" class="form-control">
                </div>
                <div class="mt-4">
                    @if($user->google2fa_enabled == \App\Constants\Status::ACTIVE)
                        <button type="submit" class="btn btn-primary animate-up-2" value="{{ \App\Constants\Status::DISABLE }}" name="status">{{ __('Disable 2FA') }}</button>
                    @else
                        <button type="submit" class="btn btn-primary animate-up-2" value="{{ \App\Constants\Status::ENABLE }}" name="status">{{ __('Enable 2FA') }}</button>
                    @endif
                </div>
            </form>
        @else
            <div class="mt-3">
                <p class="text-muted">{{ __('Enable Two Factor Authentication to protect your account') }}</p>
                <a href="{{ route('user.profile.2fa-generate') }}" class="btn btn-primary animate-up-2"><i class="fa-sharp fa-regular fa-shield-check me-2"></i>  {{ __('Generate 2FA Secret') }}</a>
            </div>
        @endif
    </div>
@endsection
