@extends('frontend.user.setting.index')
@section('title', __('My Profile'))
@section('user-setting-content')

    @if($user->email_verified_at == null)
        <div class="alert alert-danger m-2">
            {{ __('Please verify your email') }} — <a href="{{ route('user.profile.verify-email') }}" class="alert-link  text-green">{{ __('Verify Now') }} !</a>
        </div>
    @endif



    <form action="{{ route('user.profile.update') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="card-body">
            <h2 class="mb-4">👤 {{ __('My Profile') }}</h2>

            <div class="row align-items-center mb-3">
                <div class="col-auto">
                    <span class="avatar avatar-xl" style="background-image: url({{ asset($user->avatar) }})"></span>
                </div>
                <div class="col">
                    <div class="form-label">{{ __('Profile Image') }}</div>
                    <input type="file" name="avatar" class="form-control">
                </div>
            </div>

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="first_name" class="form-label">{{ __('First Name') }}</label>
                    <input type="text" id="first_name" name="first_name" class="form-control" value="{{ $user->first_name }}">
                </div>
                <div class="col-md-6">
                    <label for="last_name" class="form-label">{{ __('Last Name') }}</label>
                    <input type="text" id="last_name" name="last_name" class="form-control" value="{{ $user->last_name }}">
                </div>
            </div>

            <div class="row g-3 mt-2">
                <div class="col-md-6">
                    <label for="email" class="form-label">{{ __('Email') }}
                        @if($user->email_verified_at)
                            <span class="badge bg-success">{{ __('Verified') }}</span>
                        @else
                            <span class="badge bg-danger text-danger-fg">{{ __('Not Verified') }}</span>
                        @endif
                    </label>
                    <input type="email" id="email" name="email" class="form-control" value="{{ $user->email }}">
                </div>
                <div class="col-md-6">
                    <label for="phone" class="form-label">{{ __('Phone') }}</label>
                    <input type="tel" id="phone" name="phone" class="form-control" value="{{ $user->phone }}">
                </div>
            </div>

            <div class="row g-3 mt-2">
                <div class="col-12">
                    <label for="address" class="form-label">{{ __('Address') }}</label>
                    <input type="text" id="address" name="address" class="form-control" value="{{ $user->address }}" placeholder="Enter your address">
                </div>
            </div>

            <div class="row g-3 mt-2">
                <div class="col-md-6">
                    <label for="city" class="form-label">{{ __('City') }}</label>
                    <input type="text" id="city" name="city" class="form-control" value="{{ $user->city }}" placeholder="Enter city">
                </div>
                <div class="col-md-6">
                    <label for="state" class="form-label">{{ __('State') }}</label>
                    <input type="text" id="state" name="state" class="form-control" value="{{ $user->state }}" placeholder="Enter state">
                </div>
            </div>

            <div class="row g-3 mt-2">
                <div class="col-md-6">
                    <label for="zip" class="form-label">{{ __('Zip') }}</label>
                    <input type="text" id="zip" name="zip" class="form-control" value="{{ $user->zip }}" placeholder="Enter zip code">
                </div>
                <div class="col-md-6">
                    <label for="country" class="form-label">{{ __('Country') }}</label>
                    <input type="text" id="country" class="form-control" value="{{ $user->country }}" placeholder="Enter country" disabled>
                </div>
            </div>
        </div>

        <div class="card-footer bg-transparent mt-auto">
            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">
                    <x-icon name="check" height="20" class="me-1"/> {{ __('Update Profile') }}
                </button>
            </div>
        </div>

    </form>
@endsection
