@extends('frontend.user.setting.index')
@section('title', __('Notifications'))
@section('user-setting-content')
    <div class="card border-0">
        <div class="card-body">
            <h2 class="mb-4">🔔 {{ __('All Notifications') }}</h2>
            <div class="divide-y">
                @foreach($notifications as $notification)
                    <div>
                        <div class="row">
                            <div class="col-auto">
                                <span class="avatar">
                                     <x-icon name="{{ \App\Constants\NotificationType::ICON[$notification->data['type']] }}"
                                             class="text-{{ isset($notification->data['status']) && $notification->data['status'] == 'failed' ? 'danger' : 'green' }}"/>
                                </span>
                            </div>
                            <div class="col">
                                <div class="text-truncate">
                                    {{ $notification->data['message'] }}
                                </div>
                                <div class="text-secondary">{{ $notification->created_at->format('d M, Y H:i A') }}</div>
                            </div>
                            <div class="col-auto align-self-center">
                                @if($notification->read_at == null )
                                    <a href="{{ route('user.notifications.markAsRead', ['id' => $notification->id]) }}"
                                       class="text-red">
                                        <i class="fa-sharp fa-solid fa-bell-on"></i>
                                    </a>
                                @endif

                            </div>
                        </div>
                    </div>
                @endforeach
                {{ $notifications->links() }}

                @if(count($notifications) == 0)
                    <div class="alert alert-info">
                        {{ __('No Notification found') }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
