@extends('frontend.user.setting.index')
@section('title', __('My Profile'))
@section('user-setting-content')
    <form action="{{ route('user.profile.update-password') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="card-body">
            <h2 class="mb-4">🔑 {{ __('Update Password') }}</h2>
            <div class="mb-3">
                <label class="form-label" for="old-password">{{ __('Current Password') }}</label>
                <input type="password" name="old_password" id="old-password" class="form-control" placeholder="{{ __('Current Password') }}" required>
            </div>
            <div class="mb-3">
                <label class="form-label" for="password">{{ __('New Password') }}</label>
                <input type="password" name="password" id="password" class="form-control" placeholder="{{ __('New Password') }}" required>
            </div>
            <div class="mb-3">
                <label class="form-label" for="password_confirmation">{{ __('Confirm New Password') }}</label>
                <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" placeholder="{{ __('Confirm New Password') }}" required>
            </div>
        </div>
        <div class="card-footer bg-transparent mt-auto">
            <div class="btn-list justify-content-end">
                <button type="submit" class="btn btn-primary">
                    <x-icon name="check" height="20" class="me-1"/> {{ __('Update Password') }}
                </button>
            </div>
        </div>
    </form>
@endsection
