<div class="card mb-4">
    <div class="card-header d-flex flex-column flex-md-row justify-content-between align-items-center bg-light">
        {{-- Task Title and Description --}}
        <div>
            <h3 class="card-title mb-1 text-primary">{{ $task->name }}</h3>
            <p class="text-muted mb-0">{{ $task->description }}</p>
        </div>
    </div>
    {{-- Progress Section --}}
    <div class="card-body">
        <div class="d-flex align-items-center mb-4">
            <span class="me-2 text-muted">{{ __('Working Progress') }}</span>
            <span class="ms-auto fw-bold">{{ $task->progress }}%</span>
        </div>
        <div class="progress progress-sm">
            <div class="progress-bar bg-primary" role="progressbar" style="width: {{ $task->progress }}%;" aria-valuenow="{{ $task->progress }}" aria-valuemin="0" aria-valuemax="100"></div>
        </div>

        {{-- Task Information --}}
        <div class="row mt-4">
            <div class="col-12 col-md-6 mb-3">
                {{-- Priority Section --}}
                <div class="d-flex align-items-center">
                    <strong class="me-2">{{ __('Priority') }}:</strong>
                    <span class="badge bg-{{ $taskPriority[$task->priority] }} text-{{  $taskPriority[$task->priority] }}-fg rounded-pill">{{ title($task->priority) }}</span>
                </div>
            </div>

            <div class="col-12 col-md-6 mb-3">
                {{-- Status Section --}}
                <div class="d-flex align-items-center">
                    <strong class="me-2">{{ __('Status') }}:</strong>
                    <span class="badge bg-{{ $taskStatus[$task->status] }} text-{{  $taskStatus[$task->status] }}-fg rounded-pill">{{ title($task->status) }}</span>
                </div>
            </div>

            @if($task->attachment)
                <div class="col-12 col-md-6 mb-3">
                    {{-- File Download --}}
                    <div class="d-flex align-items-center">
                        <strong class="me-2">{{ __('Document/File') }}:</strong>
                        <a href="{{ route('user.service.task-file', $task->id) }}" class="btn btn-sm btn-primary rounded">
                            <i class="fas fa-download me-2"></i> {{ __('Download') }}
                        </a>
                    </div>
                </div>
            @endif

            <div class="col-12 col-md-6 mb-3">
                {{-- Due Date --}}
                <div class="d-flex align-items-center">
                    <strong class="me-2">{{ __('Due Date') }}:</strong>
                    <span class="text-muted">{{ $task->due_date->format('M d, Y') }}</span>
                </div>
            </div>

            <div class="col-12 col-md-6 mb-3">
                {{-- Created Date --}}
                <div class="d-flex align-items-center">
                    <strong class="me-2">{{ __('Created Date') }}:</strong>
                    <span class="text-muted">{{ $task->created_at->format('M d, Y') }}</span>
                </div>
            </div>
        </div>
    </div>
</div>
