@extends('frontend.layouts.user.app')
@section('title', __('Task Board'))
@section('page-actions')
    <div class="col-auto ms-auto d-print-none">
        <div class="btn-list">
            <a href="{{ route('user.service.my') }}" class="btn btn-primary">
                <x-svg i="list" class="icon" />
                {{ __('My Services') }}
            </a>
        </div>
    </div>
@endsection
@section('user-content')
    <div class="row g-4">
        {{-- Task Board Section --}}
        <div class="col-lg-8">
            <div class="row">
                @foreach($taskBoard as $key => $data)
                    <div class="col-12 col-md-6 col-lg-4">
                        <h4 class="mb-3 text-muted bg-white rounded p-2 border-3 border-{{ $data['border'] }} border-bottom-wide">
                            {{ $data['label'] }}
                        </h4>
                        <div class="mb-4">
                            <div class="row g-2">
                                @foreach($data['tasks'] as $task)
                                    <div class="col-12">
                                        <div class="card card-sm task-show" data-show-url="{{ route('user.service.task-show', $task->id) }}" data-bs-toggle="modal" data-bs-target="#task-show" >
                                            <div class="card-body">
                                                <h3 class="card-title">{{ $task->name }}</h3>
                                                <div class="mt-2">
                                                    <div class="row g-2 align-items-center">
                                                        <div class="col-auto">
                                                            {{ $task->progress }}%
                                                        </div>
                                                        <div class="col">
                                                            <div class="progress progress-sm">
                                                                <div class="progress-bar" style="width: {{ $task->progress }}%" role="progressbar" aria-valuenow="{{ $task->progress }}" aria-valuemin="0" aria-valuemax="100" aria-label="25% Complete">
                                                                    <span class="visually-hidden">{{ $task->progress }}% {{ __('Complete') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mt-2">
                                                    <div class="row">
                                                        <div class="col">
                                                            <span class="badge bg-{{ $taskPriority[$task->priority] }} text-{{ $taskPriority[$task->priority] }}-fg">{{ $task->priority }}</span>
                                                        </div>
                                                        <div class="col-auto">
                                                            <a href="#" class="link-warning" data-bs-toggle="modal" data-bs-target="#task-{{ $task->id }}">
                                                                <x-icon name="calendar-1"/>
                                                                {{ $task->due_date->format('d M, Y') }}
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

        {{-- Review Section --}}
        <div class="col-lg-4">
            <div class="card rounded-2 mb-4">
                <div class="card-body p-4">

                    {{-- Service Section --}}
                    <div class="info-section mb-4 d-flex justify-content-between align-items-center">
                        <h3 class="text-muted d-flex align-items-center mb-0">
                            <i class="fas fa-cogs me-2"></i>{{ __('Service') }}
                        </h3>
                        <div class="fw-bold text-primary ms-auto">{{ _tr($order->service->name) }}</div>
                    </div>

                    {{-- Service Status Section --}}
                    <div class="info-section mb-4 d-flex justify-content-between align-items-center">
                        <h3 class="text-muted d-flex align-items-center mb-0">
                            <i class="fas fa-credit-card me-2"></i>{{ __('Status') }}
                        </h3>
                        <div class="fw-bold ms-auto">
                        <span class="badge bg-{{ $orderStatus }} text-white py-1 px-3 rounded-pill" >
                            {{ $order->status }}
                        </span>
                        </div>
                    </div>


                    {{-- Price Section --}}
                    <div class="info-section mb-4 d-flex justify-content-between align-items-center">
                        <h3 class="text-muted d-flex align-items-center mb-0">
                            <i class="fas fa-dollar-sign me-2"></i>{{ __('Price') }}
                        </h3>
                        <div class="fw-bold text-success ms-auto">{{ setting('currency_symbol'). $order->transaction->amount }}</div>
                    </div>

                    {{-- Payment Status Section --}}
                    <div class="info-section mb-4 d-flex justify-content-between align-items-center">
                        <h3 class="text-muted d-flex align-items-center mb-0">
                            <i class="fas fa-credit-card me-2"></i>{{ __('Payment Status') }}
                        </h3>
                        <div class="fw-bold ms-auto">
                        <span class="badge bg-{{ $paymentStatus }} text-white py-1 px-3 rounded-pill">
                            {{ __($order->transaction->status) }}
                        </span>
                        </div>
                    </div>

                    {{-- Order Date Section --}}
                    <div class="info-section d-flex justify-content-between align-items-center">
                        <h3 class="text-muted d-flex align-items-center mb-0">
                            <i class="fas fa-calendar-alt me-2"></i>{{ __('Order Date') }}
                        </h3>
                        <div class="fw-bold text-secondary ms-auto">{{ $order->created_at->format('d M, Y') }}</div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    {{-- Task Modal --}}
    <div class="modal fade" id="task-show" tabindex="-1" aria-labelledby="task-show-label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                {{-- Modal Header --}}
                <div class="modal-header bg-light">
                    <h5 class="modal-title text-primary" id="task-show-label">{{ __('Task Details') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                {{-- Modal Body --}}
                <div class="modal-body">
                    <div id="task-show-data">

                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
@push('user-script')
    <script>
        $(document).on('click', '.task-show', function() {
            var url = $(this).data('show-url');
            $('#task-show-data').html('<div class="text-center"><div class="spinner-border text-primary" role="status"></div></div>');
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    $('#task-show-data').html(response);
                    $('#task-show').modal('show');
                }
            });
        });
    </script>

@endpush



