@extends('frontend.layouts.user.app')
@section('title', __('My Services'))
@section('user-content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="table-responsive rounded mb-3">
                <table class="table card-table table-vcenter text-nowrap mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('service Name') .' | ' . __('Order Date') }}</th>
                        <th>{{ __('Order Number') .' | ' . __('Price') }}</th>
                        <th>{{ __('Working Status') }}</th>
                        <th>{{ __('Payment Status') }}</th>
                        <th>{{ __('Details') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($orders as $order)
                        @php
                            $workingStatus = ['pending' => 'info', 'working' => 'cyan', 'completed' => 'success', 'cancel' => 'danger'][$order->status] ?? 'blue';
                            $transactionStatus = ['pending' => 'info', 'completed' => 'success', 'failed' => 'danger'][$order->transaction->status] ?? 'blue';
                        @endphp
                        <tr class="align-middle">
                            <td>
                                <div class="fw-bold">{{ _tr($order->service->name) }}</div>
                                <div class="text-muted small">{{ ucwords($order->created_at_time) }}</div>
                            </td>
                            <td>
                                <div class="fw-bold">{{ $order->order_number }}</div>
                                <div class="text-muted small">{{ setting('currency_symbol') . ucwords($order->transaction->amount . ' ' . setting('site_currency')) }}</div>
                            </td>
                            <td>
                                <span class="badge bg-{{ $workingStatus }} text-{{ $workingStatus }}-fg">{{ strtoupper($order->status) }}</span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $transactionStatus }} text-{{ $transactionStatus }}-fg">{{ strtoupper($order->transaction->status) }}</span>
                            </td>
                            <td>
                                <a href="{{ route('user.service.task-board', $order->id) }}" class="btn btn-primary">
                                    <x-icon name="task" height="20" /> {{ __('Task Board') }}
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Pagination at the end --}}
            <div class="mt-3 d-flex justify-content-end">
                {{ $orders->links() }}
            </div>

            @if(!$orders->count())
                <h4 class="text-center text-muted">{{ __('No data found') }}</h4>
            @endif
        </div>
    </div>

@endsection




