<div class="col-lg-8">
    <form class="card" method="POST" action="{{ route('user.deposit.store') }}" enctype="multipart/form-data">
        @csrf
        <div class="progress d-none" id="progress-bar">
            <div class="progress-bar progress-bar-indeterminate bg-green"></div>
        </div>
        <div class="card-body">
            <h3 class="card-title text-primary mb-4">{{ __('Add Money') }}</h3>
            <div class="row g-4">
                {{-- Deposit Method Selection --}}
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label" for="deposit-method-select">{{ __('Deposit Method') }}</label>
                        <select class="form-select" name="deposit_method"  id="deposit-method-select" aria-label="{{ __('Deposit Method') }}" required aria-describedby="deposit-method-hint">
                            <option value="0" disabled selected>{{ __('Select Deposit Method') }}</option>
                            @foreach($depositMethods as $depositMethod)
                                <option value="{{ $depositMethod->id }}" {{ old('deposit_method') == $depositMethod->id ? 'selected' : '' }} >{{ $depositMethod->name }}</option>
                            @endforeach
                        </select>
                        <small id="deposit-method-hint" class="form-hint text-muted">{{ __('Choose your preferred method of deposit.') }}</small>
                        <small class="form-hint text-danger" id="charge"></small>
                    </div>
                </div>

                {{-- Amount Input --}}
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label" for="deposit-amount">{{ __('Amount') }}</label>
                        <div class="input-group">
                            <input type="text" name="amount" value="{{ old('amount') }}" id="deposit-amount" class="form-control" placeholder="{{ __('Enter amount') }}" aria-describedby="amount-hint" oninput="this.value = validateDouble(this.value);" autocomplete="off">
                            <span class="input-group-text">{{ setting('site_currency') }}</span>
                        </div>
                        <small id="amount-hint" class="form-hint text-muted">{{ __('Enter the amount you want to deposit.') }}</small>
                        <small class="form-hint text-danger" id="amount-limit"></small>
                    </div>
                </div>
            </div>

            <div class="row g-1" id="manual-deposit-info">

            </div>

            <div class="row g-4" id="manual-deposit-row">

            </div>
        </div>

        {{-- Submit Button --}}
        <div class="card-footer text-end">
            <button type="submit" class="btn btn-primary"> <x-svg i="right-arrow"/> {{ __('Process To Deposit') }}</button>
        </div>
    </form>
</div>
