@extends('frontend.layouts.user.app')
@section('title', __('Deposit History'))
@section('page-actions')
    <div class="col-auto ms-auto d-print-none">
        <div class="btn-list">
            <a href="{{ route('user.deposit.create') }}" class="btn btn-primary">
                <x-svg i="wallet" class="icon" />
                {{ __('Deposit Now') }}
            </a>
        </div>
    </div>
@endsection
@section('user-content')
    <div class="row g-4">
        <div class="card">
            <div class="card-body border-bottom py-3">
                <div class="d-flex justify-content-end">
                    <form action="{{ route('user.deposit.history') }}">
                        <div class="d-flex align-items-center">
                            {{-- Status Filter Dropdown --}}
                            <select class="form-select me-2" name="status" aria-label="Filter by Status" >
                                <option value="all" selected >{{ __('All') }}</option>
                                @foreach(\App\Constants\TxnStatus::STATUS as $key => $value)
                                    <option value="{{ $value }}" @selected(request('status') == $value)>{{ ucwords($value) }}</option>
                                @endforeach
                            </select>
                            {{-- Search Input --}}
                            <input type="text" name="search" value="{{ request('search') }}" class="form-control me-2" placeholder="{{ __('Search...') }}" aria-label="{{ __('Search ...') }}">

                            {{-- Search Button --}}
                            <button type="submit" class="btn btn-primary d-flex align-items-center">
                                <x-svg i="search"/>
                                <span class="ms-1">{{ __('Search') }}</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table card-table table-vcenter text-nowrap datatable">
                    <thead>
                    <tr>
                        <th>{{ __('Description') .' | ' . __('TXN ID') }}</th>
                        <th>{{ __('Method') }}</th>
                        <th>{{ __('Amount') .' | ' . __('Type') }}</th>
                        <th>{{ __('Fee') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Time') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($depositHistories as $depositHistory)
                        @php
                            $color = ['pending' => 'blue', 'completed' => 'green', 'failed' => 'red'][$depositHistory->status] ?? 'blue';
                        @endphp
                        <tr>
                            <td>
                                <div>{{ $depositHistory->description }}</div>
                                <div class="text-secondary">{{ ucwords($depositHistory->txid) }}</div>
                            </td>
                            <td>
                                {{$depositHistory->method}}
                            </td>
                            <td>
                                <div class="text-{{ $color }}">
                                    {{ ($depositHistory->status == \App\Constants\TxnStatus::COMPLETED && $depositHistory->type == \App\Constants\TxnType::DEPOSIT ? '+' : '') . $depositHistory->amount . ' ' . $depositHistory->currency }}
                                </div>

                                <div class="text-secondary">{{ title($depositHistory->type) }}</div>
                            </td>
                            <td>
                                {{$depositHistory->fee . ' ' . $depositHistory->currency}}
                            </td>
                            <td>
                                <span class="badge bg-{{ $color }} text-{{ $color }}-fg">{{ strtoupper($depositHistory->status) }}</span>
                            </td>
                            <td>
                                <div>{{ $depositHistory->created_at_time }}</div>
                                <div class="text-secondary">{{ $depositHistory->created_at->diffForHumans() }}</div>
                            </td>

                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

            <div class="card-footer d-flex  ms-auto">
                {{ $depositHistories->links() }}
            </div>
        </div>
    </div>

@endsection




