<div class="col-12">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">{{ __('Recent Transactions') }}</h3>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table card-table table-vcenter text-nowrap datatable">
                    <thead>
                    <tr>
                        <th>{{ __('Description') .' | ' . __('TXN ID') }}</th>
                        <th>{{ __('Method') .' | ' . __('Method Type') }}</th>
                        <th>{{ __('Amount') .' | ' . __('Type') }}</th>
                        <th>{{ __('Fee') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Time') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($recentTransactions as $transaction)
                        @php
                            $color = ['pending' => 'blue', 'completed' => 'green', 'failed' => 'red'][$transaction->status] ?? 'blue';
                        @endphp
                        <tr>
                            <td>
                                <div>{{ $transaction->description }}</div>
                                <div class="text-secondary">{{ ucwords($transaction->txid) }}</div>
                            </td>
                            <td>
                                {{$transaction->method}}
                                <div class="text-secondary">{{ ucwords($transaction->method_type) }}</div>
                            </td>
                            <td>
                                <div class="text-{{ $color }}">
                                    {{ ($transaction->status == \App\Constants\TxnStatus::COMPLETED && $transaction->type == \App\Constants\TxnType::DEPOSIT ? '+' : '') . $transaction->amount . ' ' . $transaction->currency }}
                                </div>

                                <div class="text-secondary">{{ title($transaction->type) }}</div>
                            </td>
                            <td>
                                {{$transaction->fee . ' ' . $transaction->currency}}
                            </td>
                            <td>
                                <span class="badge bg-{{ $color }} text-{{ $color }}-fg">{{ strtoupper($transaction->status) }}</span>
                            </td>
                            <td>
                                <div>{{ $transaction->created_at_time }}</div>
                                <div class="text-secondary">{{ $transaction->created_at->diffForHumans() }}</div>
                            </td>

                        </tr>
                    @endforeach
                    </tbody>
                </table>
                @if(!$recentTransactions->count())
                    <h4 class="text-center text-muted mt-3">{{ __('No data found') }}</h4>
                @endif
            </div>
        </div>
    </div>
</div>
