<style>
    .toggleContainer {
        position: relative;
        display: flex; /* Flexbox for equal spacing */
        justify-content: space-between; /* Distribute space evenly */
        align-items: center; /* Center text vertically */
        width: 200px; /* Keep the original width */
        height: 30px; /* Set height */
        border: 3px solid #3c72fc;
        border-radius: 15px; /* Rounded corners */
        background: linear-gradient(180deg, #3c72fc -1.09%, #00060c 175.27%);
        font-weight: bold;
        color: #343434;
        cursor: pointer;
        font-size: 0.75rem; /* Slightly smaller font size for a compact layout */
    }

    .toggleContainer::before {
        content: '';
        position: absolute;
        width: 50%;
        height: 100%;
        left: 0;
        border-radius: 15px; /* Match rounded corners */
        background: white;
        transition: all 0.3s;
    }

    .toggleCheckbox:checked + .toggleContainer::before {
        left: 50%; /* Move the toggle on check */
    }

    .toggleContainer div {
        flex: 1; /* Divs take equal space */
        text-align: center; /* Center text */
        z-index: 1;
        padding: 5px 0; /* Adjust padding for better fit */
        white-space: nowrap; /* Prevent text from wrapping */
    }

    .toggleCheckbox {
        display: none; /* Hide checkbox */
    }

    .toggleCheckbox:checked + .toggleContainer div:first-child {
        color: white; /* Selected state color */
        transition: color 0.3s;
    }

    .toggleCheckbox:checked + .toggleContainer div:last-child {
        color: #343434; /* Unselected state color */
        transition: color 0.3s;
    }

    .toggleCheckbox + .toggleContainer div:first-child {
        color: #343434; /* Default first child color */
        transition: color 0.3s;
    }

    .toggleCheckbox + .toggleContainer div:last-child {
        color: white; /* Default second child color */
        transition: color 0.3s;
    }
</style>
