<a href="#" class="nav-link px-0" data-bs-toggle="dropdown" tabindex="0" aria-label="Show notifications">
    <x-svg i="bell"/>
    @php $unreadCount = auth()->user()->unreadNotifications->count(); @endphp
    @if($unreadCount > 0)
        <span class="badge bg-red text-red-fg badge-pill">{{ $unreadCount }}</span>
    @endif
</a>
<div class="dropdown-menu dropdown-menu-arrow dropdown-menu-end dropdown-menu-card notification-dropdown p-0" style="width: 350px; right: 0;">
    <div class="card">
        {{-- Card Header --}}
        <div class="card-header bg-dark d-flex justify-content-between align-items-center p-2">
            <span class="card-title text-dark-fg h5 mb-0">{{ __('Notifications') }}</span>
            <x-svg i="settings" class="text-muted text-dark-fg"/>
        </div>

        {{-- Notification List --}}
        <div class="list-group list-group-flush">
            @if($notifications->isEmpty())
                <div class="text-center p-3">
                    <x-svg i="not-found" class="text-muted" width="40"/>
                    <div class="mt-2 text-muted">{{ __('No new notifications') }}</div>
                </div>
            @else
                @foreach($notifications as $notification)
                    <a href="{{ route('user.notifications.markAsRead', ['id' => $notification->id]) }}"
                       class="bg-gray-700 list-group-item d-flex align-items-center justify-content-between p-3 text-decoration-none {{ $loop->last ? '' : 'border-bottom' }}">
                        {{-- Notification Content --}}
                        <div class="d-flex align-items-center">
                            <div class="col-auto me-2">
                                    <span class="bg-green-lt avatar">
                                        <x-icon  name="{{ \App\Constants\NotificationType::ICON[$notification->data['type']] }}" class="text-{{ (isset($notification->data['status']) && $notification->data['status'] == 'failed') ? 'danger' : 'green' }}"/>
                                    </span>
                            </div>
                            <div>
                                <div class="fw-bold">{{ $notification->data['message'] }}</div>
                                <div class="small text-muted">{{ $notification->created_at->diffForHumans() }}</div>
                            </div>
                        </div>
                    </a>
                @endforeach
            @endif
        </div>


        <div class="card-footer d-flex gap-2 p-2">
            @if(!$notifications->isEmpty())
                <a href="{{ route('user.notifications.read-all') }}" class="btn btn-primary flex-shrink-0">
                    <x-svg i="bell" class="icon me-2"/>
                    {{ __('Read All') }}
                </a>
            @endif
            <a href="{{ route('user.notifications.index') }}" class="btn btn-secondary ms-auto">
                <x-svg i="list" class="icon me-2"/>
                {{ __('All Notifications') }}
            </a>
        </div>
    </div>
</div>
