<div class="navbar-nav flex-row order-md-last">
    @if(setting('language_visibility'))
        <li class="nav-item dropdown me-3">
            <select name="locale" class="form-select"  onchange="this.options[this.selectedIndex].value && (window.location = this.options[this.selectedIndex].value);">
                @foreach($languages as $language)
                    <option value="{{ route('locale-set', $language->code) }}" @selected($language->code == app()->getLocale())>{{ $language->name }}</option>
                @endforeach
            </select>
        </li>
    @endif

    @include('frontend.layouts.user.partials._notifications')
    <div class="nav-item dropdown">
        <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown"
           aria-label="Open user menu">
                    <span class="avatar avatar-sm"
                          style="background-image: url({{ asset(auth()->user()->avatar) }})"></span>
            <div class="d-none d-xl-block ps-2">
                <div>{{ auth()->user()->full_name }}</div>
                <div class="mt-1 small text-secondary">
                  {{ __('Balance:') }} {{ auth()->user()->balance . ' ' . setting('site_currency') }}
                </div>
            </div>
        </a>
        <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-bs-theme="light">
            <div class="d-xl-none  dropdown-item align-items-center bg-gray-700">
                <div class="me-2">
                    <x-svg i="wallet" class="icon"/>
                </div>
                <div class="flex-fill">
                    <div class="fw-semibold">{{ __('Balance:') }} {{ auth()->user()->balance . ' ' . setting('site_currency') }}</div>
                </div>
            </div>
            <a href="{{ route('user.subscription.my') }}" class="dropdown-item d-flex align-items-center">
                <div class="me-2">
                    <x-svg i="subscription" class="icon text-muted"/>
                </div>
                <div class="flex-fill">
                    <div class="fw-semibold text-muted">{{ __('My Subscription') }}</div>
                </div>
            </a>
            <a href="{{ route('user.profile.index') }}" class="dropdown-item">
                <i class="fa-solid fa-user-gear me-2 text-muted"></i>
                {{ __('Settings') }}
            </a>
            <form action="{{ route('logout') }}" method="POST">
                @csrf
                <button type="submit" class="dropdown-item">
                    <x-svg i="logout"/> {{ __('Logout') }}</button>
            </form>
        </div>
    </div>
</div>
