@props(['name', 'width' => null, 'height' => null, 'class' => ''])

@php
    $svgContent = (new \App\View\Components\Svg($name))->svgContent();
    if ($svgContent) {
        $dom = new DOMDocument();
        $dom->loadXML($svgContent);
        $svg = $dom->getElementsByTagName('svg')->item(0);

        if ($width) {
            $svg->setAttribute('width', $width);
        }

        if ($height) {
            $svg->setAttribute('height', $height);
        }

        if ($class) {
            $existingClasses = $svg->getAttribute('class');
            $svg->setAttribute('class', trim("$existingClasses $class"));
        }

        $svgContent = $dom->saveXML($svg);
    }
@endphp

@if ($svgContent)
    {!! $svgContent !!}
@else
    {{-- Optional: Handle the case where the SVG file does not exist --}}
    <i class="fa-solid fa-info"></i>
@endif
