@extends('backend.user.manage')
@section('title', __('User Transaction'))
@section('user_sub_content')
    <div class="card border-0 mb-4">
        <div class="card-body">
            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Description') .' | ' . __('TXN ID') }}</th>
                        <th>{{ __('Amount') .' | ' . __('Type') }}</th>
                        <th>{{ __('Fee') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Time') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($transactions as $transaction)
                        @php
                            // Define the status color map
                            $statusColors = [
                                \App\Constants\TxnStatus::PENDING => 'info',
                                \App\Constants\TxnStatus::COMPLETED => 'success',
                                \App\Constants\TxnStatus::FAILED => 'danger'
                            ];

                            // Get the color from the status, fallback to 'blue'
                            $color = $statusColors[$transaction->status] ?? 'blue';

                            // Define the prefix based on transaction type and status
                            $prefix = null;
                            if ($transaction->status == \App\Constants\TxnStatus::COMPLETED) {
                                $prefix = match ($transaction->type) {
                                    \App\Constants\TxnType::DEPOSIT,\App\Constants\TxnType::ADD_BALANCE => '+',
                                    \App\Constants\TxnType::SUBTRACT_BALANCE => '-',
                                    default => null,
                                };
                            }

                            // Cache repeated attribute calls
                            $txid = ucwords($transaction->txid);
                            $methodType = ucwords($transaction->method_type);
                            $transactionType = title($transaction->type);
                            $transactionAmount = $prefix . $transaction->amount . ' ' . $transaction->currency;
                            $fee = $transaction->fee . ' ' . $transaction->currency;
                            $statusText = strtoupper($transaction->status);
                            $createdAtTime = $transaction->created_at_time;
                            $createdAtDiff = $transaction->created_at->diffForHumans();
                        @endphp

                        <tr class="align-middle">
                            <td>
                                <div>{{ $transaction->description }}</div>
                                <div class="text-muted small">{{ $txid }}</div>
                            </td>
                            <td>
                                <div class="text-{{ $prefix == '-' ? 'danger' : $color }}">
                                    {{ $transactionAmount }}
                                </div>
                                <div class="text-muted small">{{ $transactionType }}</div>
                            </td>
                            <td>
                                {{ $fee }}
                            </td>
                            <td>
                                <span class="badge bg-{{ $color }} text-{{ $color }}-fg">{{ $statusText }}</span>
                            </td>
                            <td>
                                <div>{{ $createdAtTime }}</div>
                                <div class="text-muted small">{{ $createdAtDiff }}</div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="d-flex justify-content-end me-4 mb-2">
            {{ $transactions->links() }}
        </div>
    </div>
@endsection
