@extends('backend.layouts.app')
@section('title')
    {{ __('Send Notification') }}
@endsection
@section('content')
    <div class="py-4">
        <div class="d-flex justify-content-between w-100 flex-wrap">
            <div class="mb-3 mb-lg-0">
                <h1 class="h4">{{  __('Send Notification') }}</h1>
            </div>
        </div>
    </div>
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <form action="{{ route('admin.users.notify') }}" method="post">
                @csrf
                <div class="mb-3">
                    <label class="form-label" for="message">{{ __('Message') }}</label>
                    <textarea name="message" id="message" class="form-control" rows="7" required></textarea>
                </div>
                <div class="mb-3">
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" value="1" id="notify_send_email"
                               name="send_email">
                        <label class="form-check-label" for="notify_send_email">
                            {{ __('Send Email') }}
                        </label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" value="1" id="notify_send_push"
                               name="send_push">
                        <label class="form-check-label" for="notify_send_push">
                            {{ __('Send Push Notification') }}
                        </label>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary"><i class="fa-light fa-envelopes-bulk"></i> {{ __('Send Notification') }}</button>
            </form>
        </div>
    </div>
@endsection
