<div class="col-12 mb-4">
    <div class="card card-body border-0 shadow mb-4 mb-xl-0">
        <h2 class="h5 mb-4"> 👤{{ __('User Settings') }}</h2>
        <form action="{{ route('admin.users.status-update') }}" method="POST">
            @csrf
            <input type="hidden" name="user_id" value="{{ $user->id }}">
            <ul class="list-group list-group-flush">
                <li class="list-group-item d-flex align-items-center justify-content-between px-0 border-bottom">
                    <div>
                        <h3 class="h6 mb-1">{{ __('Account Status') }}</h3>
                        <p class="small pe-4">{{ __('When enabled, user will be able to login') }}</p>
                    </div>
                    <div>
                        <div class="form-check form-switch">
                            <input type="hidden" name="status" value="0">
                            <input class="form-check-input" type="checkbox" value="1" name="status"
                                   @checked($user->status) id="user-notification-1">
                            <label class="form-check-label" for="user-notification-1"></label>
                        </div>
                    </div>
                </li>
                <li class="list-group-item d-flex align-items-center justify-content-between px-0">
                    <div>
                        <h3 class="h6 mb-1">{{ __('Email Verified') }}</h3>
                        <p class="small pe-4">{{ __('Enable to mark user email as verified') }}</p>
                    </div>
                    <div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" value="1" name="email_verified"
                                   @checked($user->email_verified_at) id="user-notification-2">
                            <label class="form-check-label" for="user-notification-2"></label>
                        </div>
                    </div>
                </li>
                <li class="list-group-item d-flex align-items-center justify-content-between px-0">
                    <div>
                        <h3 class="h6 mb-1">{{ __('2FA') }}</h3>
                        <p class="small pe-4">{{ __('Enable two-factor authentication to add an extra layer of security to this user account') }}</p>
                    </div>
                    <div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" value="1" name="two_factor"
                                   @checked($user->google2fa_secret) id="user-notification-2">
                            <label class="form-check-label" for="user-notification-2"></label>
                        </div>
                    </div>
                </li>
            </ul>

            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-sm btn-info"><i
                            class="fa-regular fa-floppy-disk"></i> {{ __('Save Changes') }}</button>
            </div>
        </form>

    </div>
</div>
