<div class="modal fade" id="addBalanceModal" tabindex="-1" aria-labelledby="addBalanceModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addBalanceModalLabel">  {{ __('Add or Subtract Balance') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('admin.users.balance-update') }}" method="POST">
                    @csrf
                    <input type="hidden" name="user_id" value="{{ $user->id }}">
                    <div class="mb-3">
                        <label class="form-label" for="type">{{ __('Type') }}</label>
                        <select class="form-select" id="type" name="type" aria-label="Default select example">
                            @foreach(\App\Constants\BalanceUpdateType::TYPES as  $type)
                                <option value="{{$type}}">{{ ucfirst($type)  }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="amount">{{ __('Amount') }}</label>
                        <div class="input-group mb-3">
                            <input type="text" oninput="this.value = validateDouble(this.value)" class="form-control" id="amount"
                                   name="amount" required>
                            <span class="input-group-text">{{ setting('site_currency') }}</span>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end mt-3">
                        <button type="submit" class="btn btn-info "><x-icon name="check" height="20"/> {{ __('Update Balance') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
