@extends('backend.user.index')
@section('title', __('User Manage'))
@section('user_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">{{ __('User Manage') }}</div>
    </div>
@endSection

@section('user_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="row">
                @include('backend.user.partial._sidebar')

                {{-- This location user sub content will be shown.--}}
                @include('backend.user.partial._content')
            </div>
        </div>
    </div>

    {{-- Add Balance Modal --}}
    @include('backend.user.partial._add_balance_modal')

    {{-- Notify User Modal --}}
    @include('backend.user.partial._notify_user_modal')

@endsection
@push('script')
    <script>
        'use strict';
        $(document).ready(function () {
            'use strict';
            $('.notify-user').on('click', function () {
                'use strict';
                $('#notifyUserModal').modal('show');
            });
            $('.add-balance').on('click', function () {
                'use strict';
                $('#addBalanceModal').modal('show');
            })
        });
    </script>
@endpush
