@extends('backend.user.index')
@section('title', $title)
@section('user_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">@yield('title')</div>
    </div>
@endSection

@section('user_content')

    <div class="card border-0 mb-4">
        <div class="card-body px-2">

            <div class="d-flex justify-content-end mb-3">
                <form action="{{ request()->url() }}" class="row g-2 align-items-end">
                    {{-- Extended Search Input --}}
                    <div class="col-auto">
                        <div class="input-group">
                            <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                                   placeholder="{{ __('Search by email') }}" aria-label="{{ __('Search by email') }}">
                            <button type="submit" class="btn btn-info">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>


            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Name') .' | ' . __('Balance') }}</th>
                        <th>{{ __('Email') .' | ' . __('Status') }}</th>
                        <th>{{ __('Status')  }}</th>
                        <th>{{ __('Join Time') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($users as $user)
                        <tr class="align-middle">
                            <td>
                                <div class="d-flex align-items-center">
                                    <img class="rounded-1 me-2" src="{{ asset($user->avatar) }}" alt="{{ $user->full_name }}" height="40" width="40">
                                    <div>
                                        <div class="fw-bold">{{ $user->full_name }}</div>
                                        <div class="text-muted small">{{ setting('currency_symbol').$user->getBalance() }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="fw-bold">
                                    {{ maskEmail($user->email) }}
                                </div>
                                <span class="badge bg-{{ $user->email_verified_at ? 'success' : 'danger' }}">{{ strtoupper($user->email_verified_at ? 'Verified' : 'Unverified'  ) }}</span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $user->status ? 'success' : 'danger' }}">{{ strtoupper($user->status ? 'Active' : 'Inactive'  ) }}</span>
                            </td>
                            <td>
                                <div class="fw-bold">{{ $user->created_at->format('d M, Y h:i A') }}</div>
                                <div class="text-muted small">{{ $user->created_at->diffForHumans() }}</div>
                            </td>
                            <td>
                                <a href="{{ route('admin.users.manage', $user->id) }}" class="btn btn-sm btn-info">
                                    <x-icon name="manage" height="24" width="19" /> {{ __('Manage User') }}
                                </a>
                            </td>

                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="d-flex justify-content-end me-2">
            {{ $users->links() }}
        </div>
    </div>
@endsection
