@extends('backend.user.manage')
@section('title', __('User Statistics'))
@section('user_sub_content')
    <div class="row mt-3">
        @foreach($cardStatistics as $statistic)
            <div class="col-sm-6 col-lg-4 p-2">
                <div class="card card-sm">
                    <div class="card-body p-2">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="icon-shape icon-shape-{{ $statistic['color'] }} rounded me-2 me-sm-0">
                                    <x-icon :name="$statistic['icon']" class="icon"/>
                                </div>
                            </div>
                            <div class="col">
                                <div class="font-weight-medium">
                                    {{ $statistic['title'] }}
                                </div>
                                <div class="text-muted text-nowrap">
                                    {{ $statistic['value'] }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
    <div class="row mt-3">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">{{ __('Transactions Statistics') }}</h3>
                    <div class="col-3">
                        <input type="text" name="daterange" id="user-daterange-transactions" class="form-control pt-0 pb-0" value="{{ $dateRange }}" placeholder="{{ __('Select a date range') }}" />
                    </div>
                </div>
                <div class="card-body">
                    <div id="user-transactions-chart" class="chart-lg"></div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    @include('backend.user.partial._script')
@endpush
