@extends('backend.layouts.app')
@section('content')

    {{--User Header Dynamic Content Show Here--}}
    @yield('user_header')

    <div class="card px-3 py-4">
        <ul class="nav nav-pills bg-gray-100 mx-2">
            {{-- User Menu Load From admin_menus Config File --}}
            @foreach(config('admin_menus')[1]['menus'][0]['sub_menus'] as $menu)
                <li class="nav-item  pe-0">
                    <a class="nav-link {{ isActive($menu['route'],$menu['params'] ?? [] ) }}" aria-current="page" href="{{ route($menu['route'], $menu['params'] ?? []) }}">
                        <x-icon name="{{ $menu['icon'] }}" height="18" width="18" class="me-1"/> {{ title($menu['label']) }}
                    </a>
                </li>
            @endforeach
        </ul>

        <div>
            {{-- User Dynamic Content Show Here --}}
            @yield('user_content')
        </div>
    </div>
@endSection
