@extends('backend.user.manage')
@section('title', __('User Edit'))
@section('user_sub_content')
    <div class="row mt-3">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">{{ __('Update Information') }}</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.users.info-update', $user->id) }}" method="post">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="first_name">{{ __('First Name') }}</label>
                                    <input class="form-control" type="text" name="first_name" value="{{ $user->first_name }}" placeholder="first name" autocomplete="off">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="last_name">{{ __('Last Name') }}</label>
                                    <input class="form-control" type="text" name="last_name" value="{{ $user->last_name }}" placeholder="last name">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="email">{{ __('Email Address') }}</label>
                                    <input class="form-control" type="email" name="email" value="{{ maskEmail($user->email) }}" placeholder="email address" autocomplete="off">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="phone">{{ __('Phone') }}</label>
                                    <input class="form-control" type="text" name="phone" value="{{ $user->phone }}" placeholder="phone">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="address">{{ __('Address') }}</label>
                                    <input class="form-control" type="text" name="address" value="{{ $user->address }}" placeholder="address">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="city">{{ __('City') }}</label>
                                    <input class="form-control" type="text" name="city" value="{{ $user->city }}" placeholder="city">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="state">{{ __('State') }}</label>
                                    <input class="form-control" type="text" name="state" value="{{ $user->state }}" placeholder="state">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="zip">{{ __('Zip') }}</label>
                                    <input class="form-control" type="text" name="zip" value="{{ $user->zip }}" placeholder="zip">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="country">{{ __('Country') }}</label>
                                    <input class="form-control" type="text" disabled value="{{ $user->country }}" placeholder="country">
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <button class="btn btn-info" type="submit">
                                <x-icon name="check" height="20"/>  {{ __('Update Information') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-12 mt-3">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">{{ __('Update Password') }}</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.users.password-change', $user->id) }}" method="post">
                        @csrf
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="password">{{ __('New Password') }}</label>
                                    <input class="form-control" type="password" name="password" placeholder="new password">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="mb-3">
                                    <label class="form-label" for="password_confirmation">{{ __('Confirm Password') }}</label>
                                    <input class="form-control" type="password" name="password_confirmation" placeholder="confirm password">
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <button class="btn btn-info" type="submit">
                                <x-icon name="check" height="20"/>  {{ __('Update Password') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
