@extends('backend.layouts.app')
@section('title', __('Transaction'))
@section('content')
<div class="py-4">
    <div class="d-flex justify-content-between flex-wrap">
        <h1 class="h4 mb-3 mb-lg-0">{{ __('Transaction') }}</h1>
    </div>
</div>
<div class="card border-0 mb-4">
    <div class="card-body">
        <div class="d-flex justify-content-end mb-3">
            <form action="{{ route('admin.transaction') }}" class="row g-2 align-items-end">

                <div class="col-auto">
                    <input type="hidden" name="daterange" value="{{ request('daterange') }}">
                    <div class="input-group">
                        <div id="reportrange" class="form-control">
                            <i class="fa-solid fa-calendar-days"></i>&nbsp;
                            <span></span><i class="fa-solid fa-angle-down mx-2"></i>
                        </div>
                    </div>
                </div>

                {{-- Status Filter Dropdown --}}
                <div class="col-auto">
                    <select class="form-select pe-5" name="type" aria-label="{{ __('Filter by Type') }}">
                        <option value="all" {{ request('type') == 'all' ? 'selected' : '' }}>{{ __('All Type') }}</option>
                        @foreach(\App\Constants\TxnType::TYPE as $key => $value)
                            <option value="{{ $value }}" {{ request('type') == $value ? 'selected' : '' }}>
                                {{ title($value) }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- Status Filter Dropdown --}}
                <div class="col-auto">
                    <select class="form-select pe-5" name="status" aria-label="{{ __('Filter by Status') }}">
                        <option value="all" {{ request('status') == 'all' ? 'selected' : '' }}>{{ __('All Status') }}</option>
                        @foreach(\App\Constants\TxnStatus::STATUS as $key => $value)
                            <option value="{{ $value }}" {{ request('status') == $value ? 'selected' : '' }}>
                                {{ ucwords($value) }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- Extended Search Input --}}
                <div class="col-auto">
                    <div class="input-group">
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                               placeholder="{{ __('Search...') }}" aria-label="{{ __('Search ...') }}">
                        <button type="submit" class="btn btn-info">
                            <i class="fa-solid fa-magnifying-glass"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>

        {{-- Table of Transactions --}}
        <div class="table-responsive rounded">
            <table class="table table-bordered table-striped mb-0">
                <thead class="table-light">
                <tr>
                    <th>{{ __('User | TXN ID') }}</th>
                    <th>{{ __('Amount') .' | ' . __('Type') }}</th>
                    <th>{{ __('Description | Fee') }}</th>
                    <th>{{ __('Method') .' | ' . __('Method Type') }}</th>
                    <th>{{ __('Status') }}</th>
                    <th>{{ __('Time') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach($transactions as $transaction)
                    @php
                        $statusColors = [
                            \App\Constants\TxnStatus::PENDING => 'info',
                            \App\Constants\TxnStatus::COMPLETED => 'success',
                            \App\Constants\TxnStatus::FAILED => 'danger'
                        ];
                        $color = $statusColors[$transaction->status] ?? 'primary';
                        $prefix = ($transaction->status == \App\Constants\TxnStatus::COMPLETED) ?
                            match($transaction->type) {
                                \App\Constants\TxnType::DEPOSIT, \App\Constants\TxnType::ADD_BALANCE => '+',
                                \App\Constants\TxnType::SUBTRACT_BALANCE => '-',
                                default => null
                            } : null;
                    @endphp
                    <tr>
                        <td class="fw-bold">
                            <div class="d-flex align-items-center">
                                <img class="me-2 rounded-circle" width="36" height="36" alt="Image placeholder" src="{{ asset($transaction->user->avatar) }}">
                                <div>
                                    <a href="{{ route('admin.users.edit', $transaction->user->id) }}" class="text-secondary fw-bold">{{ $transaction->user->full_name }}</a>
                                    <div class="text-muted small">{{ strtoupper($transaction->txid) }}</div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="text-{{ $color }} fw-bold">
                                {{ ($transaction->status == \App\Constants\TxnStatus::COMPLETED && $transaction->type == \App\Constants\TxnType::DEPOSIT ? '+' : '') . $transaction->amount . ' ' . $transaction->currency }}
                            </div>
                            <div class="text-muted small">{{ title($transaction->type) }}</div>
                        </td>
                        <td class="fw-bold">
                            <div class="fw-bold">{{ $transaction->description }}</div>
                            <div class="text-muted small"> {{$transaction->fee . ' ' . $transaction->currency}}</div>
                        </td>
                        <td>
                            {{ $transaction->method }}
                            <div class="text-muted small">{{ ucwords($transaction->method_type) }}</div>
                        </td>
                        <td>
                            <span class="badge bg-{{ $color }}">{{ strtoupper($transaction->status) }}</span>
                        </td>
                        <td>
                            <div>{{ $transaction->created_at_time }}</div>
                            <div class="text-muted small">{{ $transaction->created_at->diffForHumans() }}</div>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div class="d-flex justify-content-end me-4 mb-2">
        {{ $transactions->links() }}
    </div>

    @if(!$transactions->count())
        <h4 class="text-center text-muted py-3">{{ __('No data found') }}</h4>
    @endif
</div>

@endsection




