@extends('backend.support_ticket.index')
@section('title', $title)
@push('style')
    <style>
        /* Optimized attachment button */
        .chat-input label {
            cursor: pointer;
            white-space: nowrap;
        }

        /* Attachment preview styling */
        #attachment-preview {
            max-width: 100%;
            word-wrap: break-word;
        }

        /* Responsive adjustments */
        @media (max-width: 576px) {
            .chat-input .btn {
                width: 100%;
            }
            .chat-input .form-control {
                margin-top: 0.5rem;
            }
            #attachment-preview {
                margin-top: 0.5rem;
                width: 100%;
            }
        }

    </style>
@endpush
@section('support_header')
    <div class="clearfix my-3">
        <div class="fs-4 fw-semibold float-start">@yield('title')</div>
    </div>
@endSection
@section('support_content')
    <div class="card mt-4">
        {{-- Chat Header --}}
        <div class="card-header bg-gray-100  d-flex align-items-center justify-content-between">
            <h5 class="card-title mb-0">Support Chat</h5>
            <form action="{{ route('admin.support-ticket.status-update', $ticket->id) }}" method="POST">
                @csrf
                @method('PUT')
                <select name="ticket_status" class="form-select custom-select-200" onchange="this.form.submit()">
                    @foreach(\App\Constants\TicketStatus::STATUS as $key => $value)
                        <option value="{{ $value }}" @selected($ticket->status == $value)>{{ title($value) }}</option>
                    @endforeach
                </select>
            </form>
        </div>

        {{-- Chat Messages --}}
        <div class="card-body chat-box px-3" id="chat-box" style="max-height: 400px; overflow-y: auto;">

            <div class="d-flex justify-content-start mb-3">
                {{-- Avatar --}}
                <div class="me-3">
                    <img src="{{ asset($ticket->user->avatar) }}" class="rounded-circle" alt="User" width="40" height="40">
                </div>

                {{-- Message Card --}}
                <div class="card bg-tertiary text-white" style="max-width: 75%;">
                    <div class="card-body p-3">
                        {{-- Message Content --}}
                        <p class="mb-1">{{ $ticket->message }}</p>

                        {{-- File Attachment (if exists) --}}
                        @if($ticket->attachment)
                            <a href="{{ route('admin.download-file',['file' => $ticket->attachment]) }} " class="d-block mt-2 text-decoration-none text-secondary small" target="_blank">
                                <i class="fa-solid fa-download"></i> {{ __('Download Attachment') }}
                            </a>
                        @endif

                        {{-- Time and User Info --}}
                        <div class="d-flex justify-content-between align-items-center mt-2">
                            <small class="text-muted me-2">
                                <i class="fa-solid fa-user-tie"></i> {{ $ticket->user->full_name  }}
                            </small>
                            <small class="text-muted">
                                <i class="fa-regular fa-clock-ten-thirty"></i> {{ $ticket->created_at->format('g:i A') }}
                            </small>
                        </div>
                    </div>
                </div>
            </div>


            @foreach($ticket->messages as $message)
                <div class="d-flex {{ $message->admin_id ? 'justify-content-end' : 'justify-content-start' }} mb-3">
                    {{-- Avatar --}}
                    @if(!$message->admin_id)
                        <div class="me-3">
                            <img src="{{ asset($ticket->user->avatar) }}" class="rounded-circle" alt="User" width="40" height="40">
                        </div>
                    @endif

                    {{-- Message Card --}}
                    <div class="card {{ $message->admin_id ? 'bg-info text-white' : 'bg-tertiary text-white' }} " style="max-width: 75%;">
                        <div class="card-body p-3">
                            {{-- Message Content --}}
                            <p class="mb-1">{{ $message->message }}</p>

                            {{-- File Attachment (if exists) --}}
                            @if($message->attachment)
                                <a href="{{ route('admin.download-file',['file' => $message->attachment]) }} " class="d-block mt-2 text-decoration-none text-secondary small" target="_blank">
                                    <i class="fa-solid fa-download"></i> {{ __('Download Attachment') }}
                                </a>
                            @endif

                            {{-- Time and User Info --}}
                            <div class="d-flex justify-content-between align-items-center mt-2">
                                <small class="text-muted me-2">
                                    <i class="fa-solid fa-user-tie"></i> {{ $message->admin_id ? (auth()->user()->name ?? '') : $ticket->user->full_name }}
                                </small>
                                <small class="text-muted">
                                    <i class="fa-regular fa-clock-ten-thirty"></i> {{ $message->created_at->format('g:i A') }}
                                </small>
                            </div>
                        </div>
                    </div>

                    {{-- Admin Avatar --}}
                    @if($message->admin_id)
                        <div class="ms-3">
                            <img src="{{ asset(auth()->user()->avatar) }}" class="rounded-circle" alt="Admin" width="40" height="40">
                        </div>
                    @endif
                </div>
            @endforeach
        </div>

        {{-- Chat Input --}}
        <div class="card-footer chat-input bg-light border-top-0 p-3">
            <form action="{{ route('admin.support-ticket.reply', $ticket->id) }}" method="POST" enctype="multipart/form-data" class="row g-3 align-items-start">
                @csrf

                {{-- File Attachment Input --}}
                <div class="col-12 col-sm-auto">
                    <label for="file-input" class="btn btn-info border d-flex align-items-center">
                        <i class="fa-regular fa-paperclip me-2"></i> {{ __('Attachment') }}
                    </label>
                    <input type="file" id="file-input" name="attachment" class="d-none" aria-label="Upload" onchange="showFileName(this)">
                </div>

                {{-- Attachment Preview (hidden initially) --}}
                <div class="col-12 col-sm-auto d-none" id="attachment-preview">
                    <span class="badge bg-secondary p-2" id="file-name">{{ __('No file selected') }}</span>
                </div>

                {{-- Text Input --}}
                <div class="col-12 col-sm flex-grow-1">
                    <textarea id="message-textarea" name="message" class="form-control" rows="1" placeholder="Type your message here..." required></textarea>
                </div>

                {{-- Send Button --}}
                <div class="col-12 col-sm-auto text-sm-end text-center">
                    <button class="btn btn-info d-flex align-items-center w-100 w-sm-auto" type="submit">
                        <i class="fa-regular fa-paper-plane-top"></i>
                        <span class="mx-2">{{ __('Send Reply') }}</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
    <script>
        function showFileName(input) {
            const file = input.files[0];
            if (file) {
                const fileName = document.getElementById('file-name');
                const attachmentPreview = document.getElementById('attachment-preview');

                fileName.textContent = file.name;
                attachmentPreview.classList.remove('d-none');
            }
        }

        // Adjust textarea rows based on screen size
        function adjustTextareaRows() {
            const textarea = document.getElementById('message-textarea');
            if (window.innerWidth <= 576) {
                textarea.setAttribute('rows', '2');
            } else {
                textarea.setAttribute('rows', '1');
            }
        }

        // Run adjustTextareaRows on page load and window resize
        window.addEventListener('load', adjustTextareaRows);
        window.addEventListener('resize', adjustTextareaRows);
    </script>

@endpush
