@extends('backend.support_ticket.index')
@section('title', $title)
@section('support_header')
    <div class="clearfix my-3">
        <div class="fs-4 fw-semibold float-start">@yield('title')</div>
    </div>
@endSection
@section('support_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Title') .' | ' . __('User') }}</th>
                        <th>{{ __('Ticket ID') . ' | ' . __('Priority') }}</th>
                        <th>{{ __('Opening Time')  }}</th>
                        <th>{{ __('Category') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($tickets as $ticket)
                        @php
                            $color = ['pending' => 'info','in_progress' => 'tertiary', 'completed' => 'success', 'closed' => 'danger' ][$ticket->status];
                            $priorityColor = ['low' => 'info', 'medium' => 'warning', 'high' => 'danger'][$ticket->priority] ?? 'blue';
                        @endphp
                        <tr class="align-middle ">
                            <td>
                                <div class="fw-bold">{{ $ticket->title }}</div>
                                <div class="text-muted small text-info">
                                  <a href="#">{{ title($ticket->user->full_name) }}</a>
                                </div>
                            </td>
                            <td>
                                <div class="text-primary fw-bold">
                                    {{ ucwords($ticket->uuid) }}
                                </div>
                                <div class="text-muted small">
                                    <span class="badge bg-{{ $priorityColor }} ">{{ strtoupper($ticket->priority) }}</span>
                                </div>

                            </td>
                            <td>
                                <div class="fw-bold">{{ $ticket->created_at->format('Y-m-d H:i') }}</div>
                                <div class="text-muted small">{{ $ticket->created_at->diffForHumans() }}</div>
                            </td>
                            <td class="fw-bold">
                                {{ $ticket->category->name ?? __('Uncategorized')  }}
                            </td>
                            <td>
                                <span class="badge bg-{{ $color }} ">{{ strtoupper(title($ticket->status)) }}</span>
                                @if($ticket->is_resolved)
                                    <span class="badge bg-success ms-1">{{ __('Resolved') }}</span>
                                @endif
                            </td>
                            <td class="fw-bold">
                                <a href="{{ route('admin.support-ticket.show', $ticket->id) }}" class="btn btn-tertiary" ><x-svg i="chat" height="20"/>{{ __('Support Now') }}</a>
                            </td>

                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>
@endsection
