@extends('backend.layouts.app')
@section('title')
    {{ __('Support Category') }}
@endsection

@section('content')
    <div class="py-4">
        <div class="d-flex justify-content-between w-100 flex-wrap">
            <div class="mb-3 mb-lg-0">
                <h1 class="h4">{{ __('Support Category') }}</h1>
            </div>
            <div class="btn-toolbar  mb-md-0 mb-2">
                <button type="button" class="btn btn-sm btn-info d-inline-flex align-items-center"
                        data-bs-toggle="modal" data-bs-target="#new-category-modal">
                    <x-svg i="add" class="me-1" height="24" />
                    {{ __('Add New') }}
                </button>
            </div>
        </div>
    </div>

    <div class="card border-0 shadow mb-4">
        <div class="table-responsive rounded">
            <table class="table table-striped table-hover table-bordered align-middle">
                <thead class="table-light">
                <tr>
                    <th scope="col">{{ __('Name') }}</th>
                    <th scope="col">{{ __('Status') }}</th>
                    <th scope="col">{{ __('Created At') }}</th>
                    <th scope="col">{{ __('Action') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach($categories as $category)
                    <tr>
                        <td><span class="fw-bold">{{ $category->name }}</span></td>
                        <td>
                            <span class="badge bg-{{ $category->status ? 'success' : 'danger' }}">{{ strtoupper($category->status ? 'ACTIVE' : 'INACTIVE') }}</span>
                        </td>
                        <td>
                            <span class="fw-bold"> {{ $category->created_at->diffForHumans() }}</span>
                        </td>
                        <td>
                            <div class="btn-group" role="group" aria-label="Actions">
                                <a href="javascript:void(0)" class="btn btn-sm btn-info edit-modal"
                                   data-edit-url="{{ route('admin.support-ticket.category.edit', $category->id) }}">
                                    <x-icon name="edit" height="20" /> {{ __('Edit') }}
                                </a>
                                <a href="javascript:void(0)" class="btn btn-sm btn-danger delete"
                                   data-url="{{ route('admin.support-ticket.category.destroy', $category->id) }}">
                                    <x-icon name="delete-3" height="20" /> {{ __('Delete') }}
                                </a>

                            </div>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

        @if($categories->count() == 0)
                <h4 class="text-center text-muted py-3">{{ __('No Data Available') }}</h4>
            @endif
        </div>
    </div>

    {{-- New Nav Modal --}}
    @include('backend.support_ticket.category.partial._new_category_modal')

    {{-- Edit Modal --}}
    @include('backend.support_ticket.category.partial._edit_category_modal')


@endsection

@section('script')
    <script>
        $(document).ready(function () {
            editFormByModal('edit-category-modal', 'edit-category-data');
        });
    </script>
@endsection
