@extends('backend.subscription.index')
@section('title', $title)
@section('order_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">@yield('title')</div>
    </div>
@endSection

@section('subscription_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Client Name') .' | ' . __('Subscribe Date') }}</th>
                        <th>{{ __('PLan Name') }}</th>
                        <th>{{ __('Price') .' | ' . __('Duration') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Payment Status') }}</th>
                        <th>{{ __('Expire Date') }}</th>
                        @if(isset($paymentAction) && auth()->user()->can('subscription-manage'))
                            <th>{{ __('Action') }}</th>
                        @endif
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($subscriptions as $subscription)
                        @php
                            $subscriptionStatus = ['pending' => 'info', 'active' => 'secondary', 'expired' => 'warning','cancelled' => 'danger'][$subscription->status] ?? 'blue';
                            $transactionStatus = ['pending' => 'info',  'completed' => 'success', 'failed' => 'danger' ][$subscription->transaction->status] ?? 'blue';
                            $transaction = $subscription->transaction;
                            $isPaymentCompleted = $transaction->status == \App\Constants\TxnStatus::COMPLETED;
                            $isManualPayment = $transaction->method_type == \App\Constants\MethodType::MANUAL;
                            $isManualPending = $transaction->method_type == \App\Constants\MethodType::MANUAL && $transaction->status == \App\Constants\TxnStatus::PENDING;
                        @endphp
                        <tr class="align-middle ">
                            <td>
                                <div class="fw-bold">{{ $subscription->user->full_name }}</div>
                                <div class="text-muted small">{{ ucwords($subscription->created_at_time) }}</div>
                            </td>
                            <td class="fw-bold">
                                {{ _tr($subscription->plan->name) }}
                            </td>
                            <td>
                                <div class="fw-bold">{{ setting('currency_symbol').$transaction->amount. ' ' . setting('site_currency') }}</div>
                                <div class="text-muted small">{{ ucwords($subscription->duration_type) }}</div>
                            </td>
                            <td class="fw-bold">
                                <span class="badge bg-{{ $subscriptionStatus }} ">{{ strtoupper($subscription->status) }}</span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $transactionStatus }} ">{{ strtoupper($subscription->transaction->status) }}</span>
                            </td>
                            <td>
                                <div class="fw-bold">{{ $subscription->expiry_date->format('M d, Y') }}</div>
                                <div class="text-muted small">{{ $subscription->expiry_date->diffForHumans() }}</div>
                            </td>
                            @can('subscription-manage')

                            @if (isset($paymentAction))
                                <td>
                                    @if ($isManualPending || $isManualPayment)
                                        <button class="btn btn-tertiary edit-modal"
                                                data-edit-url="{{ route('admin.deposit.deposit-request-action', $transaction->txid) }}"
                                                type="button">
                                            <x-svg i="action" height="20"/> {{ __('Payment Approval') }}
                                        </button>
                                    @else
                                        <span class="btn btn-primary">{{ __('No Action Available') }}</span>
                                    @endif
                                </td>
                            @endif

                            @endcan
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="d-flex justify-content-end me-4 mb-2">
            {{ $subscriptions->links() }}
        </div>

        @if(!$subscriptions->count())
            <h4 class="text-center text-muted py-3">{{ __('No data found') }}</h4>
        @endif
    </div>
    @include('backend.deposit.partials._deposit_action_modal')

@endsection
@push('script')
    <script>
        $(document).ready(function () {
            'use strict';
            editFormByModal('deposit-action-modal', 'deposit-action-data', true, true);
        });
    </script>

@endpush
