<div class="card mb-3 mt-4">
    <div class="card-header p-2 d-flex justify-content-between align-items-center bg-info text-white">
        <h5 class="card-title mb-0 px-3">{{ __('Side Content') }}</h5>
    </div>
    <div class="card-body p-3">
        <div class="row mb-3">
            <div class="col-xl-12">
                <label class="form-label">{{ __('Title') }}</label>
                <input class="form-control" type="text" name="side_content[title]" placeholder="Ex: Opening Hours" value="{{ old('side_content.title', $side_content['title'] ?? '') }}">
            </div>
        </div>
        <div class="table-responsive rounded">
            <table class="table table-sm table-bordered mb-0">
                <thead class="table-info">
                <tr>
                    <th>
                        {{ __('Icon') }}
                        <a href="https://fontawesome.com/v5/search" target="_blank">
                            <span class="badge bg-info">{{ __('Font Awesome 5 Icons') }}</span>
                        </a>
                    </th>
                    <th>{{ __('Text') }}</th>
                    <th class="text-center">{{ __('Action') }}</th>
                </tr>
                </thead>
                <tbody id="append-side-content-{{ $langCode ?? config('app.fallback_locale') }}">
                @if(isset($side_content) && count($side_content) > 0)
                    @foreach($side_content['list'] as $key => $content)
                        <tr class="align-middle">
                            <td>
                                <input type="text" class="form-control min-w-100" placeholder="{{ __('Enter Icon') }}" name="side_content[list][{{ $key }}][icon]" value="{{ old('side_content.icon.'.$key, $content['icon'] ?? '') }}">
                            </td>
                            <td>
                                <input type="text" class="form-control min-w-100" placeholder="{{ __('Enter Text') }}" name="side_content[list][{{ $key }}][text]" value="{{ old('side_content.text.'.$key, $content['text'] ?? '') }}">
                            </td>
                            <td class="text-center"><button class="btn btn-danger text-white delete-field" type="button"><x-icon name="trash" height="20"/>{{ __('Delete') }}</button></td>
                        </tr>
                    @endforeach
                @else
                    <tr class="align-middle">
                        <td>
                            <input type="text" class="form-control min-w-100" placeholder="{{ __('Enter Icon') }}" name="side_content[list][0][icon]">
                        </td>
                        <td>
                            <input type="text" class="form-control min-w-100" placeholder="{{ __('Enter Text') }}" name="side_content[list][0][text]">
                        </td>
                        <td class="text-center"><button class="btn btn-danger text-white delete-field" type="button"><x-icon name="trash" height="20"/>{{ __('Delete') }}</button></td>
                    </tr>
                @endif
                </tbody>
            </table>
            {{-- Add New Row Button --}}
            <div class="d-flex justify-content-start mt-3">
                <a href="javascript:void(0)"  class="add-new-side-content btn btn-info d-flex align-items-center px-3">
                    <x-icon name="add" height="20" class="me-2"/> {{ __('Add New Side Content') }}
                </a>
            </div>
        </div>
    </div>
</div>
