<div class="card mb-3 mt-4">
    <div class="card-header p-2 d-flex justify-content-between align-items-center bg-light border-bottom bg-info text-white">
        <h5 class="card-title mb-0 px-3">{{ __('FAQ Content') }}</h5>
    </div>

    <div class="card-body p-3 ">
        {{-- Title Input --}}
        <div class="row mb-4">
            <div class="col-12">
                <label for="faqContentTitle" class="form-label">{{ __('Title') }}</label>
                <input type="text" id="faqContentTitle" name="faq_content[title]" class="form-control" placeholder="Ex: Opening Hours" value="{{ old('faq_content.title', $faqs['title'] ?? '') }}">
            </div>
        </div>

        {{-- Summary Textarea --}}
        <div class="row mb-4">
            <div class="col-12">
                <label for="faqContentSummary" class="form-label">{{ __('Summery') }}</label>
                <textarea id="faqContentSummary" name="faq_content[summery]" class="form-control" rows="4" placeholder="Enter a brief summary">{{ old('faq_content.summery', $faqs['summery'] ?? '') }}</textarea>
            </div>
        </div>

        {{-- FAQ Table --}}
        <div class="table-responsive rounded">
            <table class="table table-sm table-bordered mb-0">
                <thead class="table-info">
                <tr>
                    <th>{{ __('Question') }}</th>
                    <th>{{ __('Answer') }}</th>
                    <th class="text-center">{{ __('Action') }}</th>
                </tr>
                </thead>
                <tbody id="append-faq-content-{{ $langCode ?? config('app.fallback_locale') }}">
                    @if(isset($faqs['list']) && count($faqs['list']) > 0)
                        @foreach($faqs['list'] as $key => $content)
                            <tr class="align-middle">
                                <td>
                                    <input type="text" name="faq_content[list][{{$key}}][question]" class="form-control min-w-100" placeholder="{{ __('Enter Question') }}" value="{{ old('faq_content.list.'.$key.'.question', $content['question'] ?? '') }}">
                                </td>
                                <td>
                                    <textarea name="faq_content[list][{{$key}}][answer]" class="form-control min-w-100" rows="4" placeholder="{{ __('Enter Answer') }}">{{ old('faq_content.list.'.$key.'.answer', $content['answer'] ?? '') }}</textarea>
                                </td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-sm btn-danger delete-faq-field">
                                        <x-icon name="trash" height="20"/> {{ __('Delete') }}
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr class="align-middle">
                            <td>
                                <input type="text" name="faq_content[list][0][question]" class="form-control min-w-100" placeholder="{{ __('Enter Question') }}">
                            </td>
                            <td>
                                <textarea name="faq_content[list][0][answer]" class="form-control min-w-100" rows="4" placeholder="{{ __('Enter Answer') }}"></textarea>
                            </td>
                            <td class="text-center">
                                <button type="button" class="btn btn-sm btn-danger delete-faq-field">
                                    <x-icon name="trash" height="20"/> {{ __('Delete') }}
                                </button>
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>

        {{-- Add New FAQ Button --}}
        <div class="d-flex justify-content-start mt-3">
            <button type="button"  class="add-new-faq-content btn btn-info d-flex align-items-center px-3">
                <x-icon name="add" height="20" class="me-2"/> {{ __('Add New FAQ') }}
            </button>
        </div>
    </div>
</div>
