@extends('backend.layouts.app')
@section('title', __('All Services'))
@section('content')
    <div class="clearfix  py-4">
        <div class="h4 fw-semibold float-start">{{  __('All Services') }}</div>
        <a href="{{ route('admin.service.create') }}" class="btn btn-info float-end">
            <x-icon name="add"  height="24" />{{ __('Create Service') }}
        </a>
    </div>

    <div class="card order-0 shadow mb-4">
        <div class="table-responsive rounded">
            <table class="table table-bordered  table-striped mb-0">
                <thead class="table-light">
                <tr>
                    <th>{{ __('Icon')  }}</th>
                    <th>{{ __('Name')  }}</th>
                    <th>{{ __('Price') }}</th>
                    <th>{{ __('status') }}</th>
                    <th>{{ __('Action') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach($services as $service)

                    <tr class="align-middle ">
                        <td>
                            <img class="avatar" src="{{ asset($service->dark_icon) }}"  height="30" alt="{{ setting('site_title') }}">
                        </td>
                        <td class="fw-bold">
                            {{ $service->translate('name') }}
                        </td>
                        <td>
                            {{ setting('currency_symbol') }}{{$service->price . ' ' . setting('site_currency', 'USD')}}
                        </td>
                        <td>
                            <span class="badge bg-{{ __($service->status ? 'success' : 'danger') }}">{{ __($service->status ? 'ACTIVE' : 'INACTIVE') }}</span>
                        </td>
                        <td>
                            <a href="{{ route('admin.service.edit', $service->id) }}" class="btn btn-sm btn-info"><x-icon name="edit" height="20" />{{ __('Edit') }}</a>
                            <a href="{{ route('service.details', ['slug' => $service->slug]) }}" target="_blank" class="btn btn-sm btn-tertiary text-white"><x-icon name="eye-1" height="18" />{{ __('Show') }}</a>
                            <a href="javascript:void(0)" class="btn btn-sm btn-danger delete" data-url="{{ route('admin.service.destroy', $service->id) }}"><x-icon name="delete-3" height="20" />{{ __('Delete') }}</a>
                        </td>

                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>

@endsection

