@extends('backend.layouts.app')
@section('title', __('Update Service'))
@section('content')
    <div class="clearfix my-3">
        <h4 class="fw-semibold float-start">{{ __('Update Service') }}</h4>
        <a href="{{ route('admin.service.index') }}" class="btn btn-info float-end">
            <x-icon name="back" height="24"/> {{ __('Back') }}
        </a>
    </div>

    <div class="card border-0 mb-4">
        <div class="card-body">

            {{-- Tab --}}
            <nav>
                <div class="nav nav-tabs mb-4" id="nav-tab" role="tablist">
                    @foreach($languages as $code => $name)
                        <a class="lang-tab nav-item nav-link @if($code == config('app.static_default_language')) active @endif" id="nav-home-tab" data-lang="{{ $code }}" data-bs-toggle="tab" href="#nav-{{$code}}" role="tab"
                           aria-controls="nav-home" aria-selected="true">{{ $name }}</a>
                    @endforeach
                </div>
            </nav>

            <div class="tab-content" id="nav-tabContent">

                @foreach($languages->keys() as $langCode)

                    <div class="tab-pane fade  @if($langCode == config('app.static_default_language')) show active @endif" id="nav-{{$langCode}}" role="tabpanel" aria-labelledby="nav-home-tab">
                        <form action="{{ route('admin.service.update', $service->id) }}" method="post" enctype="multipart/form-data">
                            @method('PUT')
                            @csrf
                            <input type="hidden" name="lang" value="{{ $langCode }}">

                            @if($langCode == config('app.static_default_language'))
                                <div class="row mb-3">
                                    @foreach(['light_icon', 'dark_icon', 'cover', 'video_cover'] as $field)
                                        <div class="col-lg-3 col-md-3 col-12">
                                            <label class="form-label" for="{{ $field }}">{{ __(ucfirst($field)) }}</label>
                                            <x-img-up :old="$service->{$field}" name="{{ $field }}"/>
                                        </div>
                                    @endforeach
                                </div>
                            @endif

                            <div class="row mb-3">
                                <div class="col-lg-6 col-md-6 col-12">
                                    <label class="form-label" for="name">{{ __('Service Name') }}</label>
                                    <input class="form-control service-name" type="text" name="name" placeholder="Service Name" value="{{ old('name', $service->translate('name',$langCode)) }}">
                                </div>
                                @if($langCode == config('app.static_default_language'))
                                    <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
                                        <label class="form-label" for="price">{{ __('Price') }}</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="price" oninput="this.value = validateDouble(this.value)" placeholder="Ex: 100, 200, etc..." value="{{ old('price', $service->price) }}">
                                            <span class="input-group-text">{{ setting('site_currency') }}</span>
                                        </div>
                                    </div>
                                @endif
                            </div>

                            @if($langCode == config('app.static_default_language'))
                                <div class="row mb-3">
                                    <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
                                        <label class="form-label" for="slug">{{ __('Slug') }}</label>
                                        <input class="form-control service-slug" type="text" name="slug" placeholder="Ex: SEO Optimization, etc..." value="{{ old('slug', $service->slug) }}">
                                    </div>

                                    <div class="col-lg-6 col-md-6 col-12">
                                        <label class="form-label" for="video_link">{{ __('Video Link') }}</label>
                                        <input class="form-control" type="url" name="video_link" placeholder="Ex: https://www.youtube.com/watch?v=xxxxxxxx" value="{{ old('video_link', $service->video_link) }}">
                                    </div>
                                </div>
                            @endif

                            <div class="row mb-3">
                                <div class="col-xl-12">
                                    <label class="form-label">{{ __('Description') }}</label>
                                    <textarea class="summernote form-control" name="description">{{ old('description', $service->translate('description',$langCode)) }}</textarea>
                                </div>
                            </div>

                            @if($langCode == config('app.static_default_language'))
                                <div class="row mb-3">
                                    <div class="col-xl-12">
                                        <label class="form-label">{{ __('Tags') }}</label>
                                        <input class="form-control tags-evs" type="text" name="tags" placeholder="Ex: seo, google,tech,etc" value="{{ old('tags', $service->tags) }}">
                                    </div>
                                </div>
                            @endif

                            @include('backend.services.partials.side_content', ['side_content' => $service->translate('side_content', $langCode)])

                            @include('backend.services.partials.faq_content', ['faqs' => $service->translate('faq_content', $langCode)])

                            @if($langCode == config('app.static_default_language'))
                                <div class="row">
                                    <div class="col-md-2 mb-3 mt-2">
                                        <div class="card">
                                            <div class="form-check form-switch card-body p-2 rounded d-flex align-items-center">
                                                <label class="form-check-label mb-0 flex-grow-1" for="status">{{ __('Status') }}</label>
                                                <input class="form-check-input coevs-switch flex-shrink-0 ms-2" type="checkbox" role="switch" name="status" value="1" @checked($service->status) id="status">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <div class="d-flex justify-content-end">
                                <button class="btn btn-info mt-2 animate-up-2" type="submit">
                                    <x-icon name="check" height="20"/> {{ __('Update Service') }}
                                </button>
                            </div>
                        </form>
                    </div>
                @endforeach
            </div>
            {{-- End of tab --}}
        </div>
    </div>
@endsection
@push('script')
    @include('backend.services.partials._service_script')
@endpush
