{{-- Icon and Background Shape --}}
@if((isset($langCode) && $langCode == config('app.fallback_locale')) || !isset($langCode))
    <div class="row mb-3">
        <div class="col-lg-6 col-md-6 col-12">
            <label class="form-label" for="icon">{{ __('Icon') }}</label>
            @if (isset($planData))
                <x-img-up name="icon" :old="$planData->icon" id="icon-preview"/>
            @else
                <x-img-up name="icon" id="icon-preview"/>
            @endif
        </div>
        <div class="col-lg-6 col-md-6 col-12">
            <label class="form-label" for="background_shape">{{ __('Background Shape') }}</label>
            @if (isset($planData))
                <x-img-up name="background_shape" :old="$planData->background_shape" id="background-preview"/>
            @else
                <x-img-up name="background_shape" id="background-preview"/>
            @endif
        </div>
    </div>
@endif

{{-- Name Field --}}
<div class="row">
    <div class="col-12 col-md-12">
        <div class="mb-3">
            <label class="form-label">{{ __('Name') }}</label>
            <input type="text" name="name" class="form-control" placeholder="Enter name" required
                   value="{{ isset($planData) && isset($langCode) ? $planData->translate('name', $langCode) : old('name') }}">
        </div>
    </div>
</div>

@if((isset($langCode) && $langCode == config('app.fallback_locale')) || !isset($langCode))
    <div class="row">
        {{-- Monthly and Yearly Price Fields --}}
        <div class="col-12 col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Monthly Price') }}</label>
                <div class="input-group">
                    <input type="text" class="form-control" name="monthly_price"
                           oninput="this.value = validateDouble(this.value)"
                           aria-label="Amount (to the nearest dollar)"
                           value="{{ isset($planData) ? $planData->monthly_price : old('monthly_price') }}">
                    <span class="input-group-text">{{ setting('site_currency') }}</span>
                </div>
            </div>
        </div>

        <div class="col-12 col-md-6">
            <div class="mb-3">
                <label class="form-label">{{ __('Yearly Price') }}</label>
                <div class="input-group">
                    <input type="text" class="form-control" name="yearly_price"
                           oninput="this.value = validateDouble(this.value)"
                           aria-label="Amount (to the nearest dollar)"
                           value="{{ isset($planData) ? $planData->yearly_price : old('yearly_price') }}">
                    <span class="input-group-text">{{ setting('site_currency') }}</span>
                </div>
            </div>
        </div>
    </div>
@endif

<div class="row">
    {{-- Features Field (Dynamic Feature Addition) --}}
    <div class="col-12 mb-3">
        <div class="mb-3" id="feature-list-{{ $langCode ?? 'default' }}">
            <label class="form-label">{{ __('Features') }}</label>
            @if (isset($planData) && isset($langCode))
                @foreach ($planData->translate('features', $langCode) as $feature)
                    <div class="input-group mb-2 feature-input">
                        <input type="text" class="form-control" name="features[]" placeholder="Enter feature" required
                               value="{{ $feature }}">
                        <button class="btn btn-danger remove-feature" type="button">
                            <i class="fa-solid fa-trash"></i>
                        </button>
                    </div>
                @endforeach
            @else
                <div class="input-group mb-2 feature-input">
                    <input type="text" class="form-control" name="features[]" placeholder="Enter feature" required>
                    <button class="btn btn-danger remove-feature" type="button">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </div>
            @endif
        </div>
        <button class="btn btn-sm btn-tertiary add-feature" type="button">
            <x-icon name="plus" height="20"/> {{ __('Add Feature') }}
        </button>
    </div>
</div>

@if((isset($langCode) && $langCode == config('app.fallback_locale')) || !isset($langCode))
    <div class="row">
        {{-- Status Toggle Switch --}}
        <div class="col-lg-4 col-md-4 col-4 mb-3">
            <label class="form-label" for="status">{{ __('Status') }}</label>
            <div class="form-check form-switch">
                <input class="form-check-input coevs-switch" type="checkbox" name="status" value="1"
                       @if (isset($planData) && $planData->status) checked @endif>
            </div>
        </div>
    </div>
@endif

{{-- Submit Button --}}
<div class="text-end">
    <button class="btn btn-info" type="submit">
        <x-icon name="check" height="20"/> @if (isset($planData)){{ __('Update Plan') }} @else {{ __('Create Plan') }} @endif
    </button>
</div>
