@extends('backend.layouts.app')
@section('title', __('All Plan'))
@section('content')
    <div class="clearfix  py-4">
        <div class="h4 fw-semibold float-start">{{  __('All Plan') }}</div>
        <a href="javascript:void(0)" class="btn btn-info float-end create-plan" >
            <x-icon name="add"  height="24" />{{ __('Create Plan') }}
        </a>
    </div>

    <div class="card border-0 mb-4">

        <div class="card-body">
            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Icon') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Monthly Price') }}</th>
                        <th>{{ __('Yearly Price')  }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                        @foreach($plans as $plan)
                            <tr>
                                <td class="pt-1 pb-0">
                                    <img src="{{ asset($plan->icon) }}" class="rounded" height="40" alt="Avatar" style="object-fit: contain;">
                                </td>
                                <td class="fw-bold">{{ _tr($plan->name) }}</td>
                                <td>
                                    <div class="fw-bold">{{ setting('currency_symbol').$plan->monthly_price . ' ' . setting('site_currency') }}</div>
                                </td>
                                <td>
                                    <div class="fw-bold">{{ setting('currency_symbol').$plan->yearly_price . ' ' . setting('site_currency') }}</div>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $plan->status ? 'success' : 'danger' }}">{{ strtoupper($plan->status ? 'ACTIVE' : 'INACTIVE') }}</span>
                                </td>
                                <td class="pt-1 pb-0">
                                    <a href="javascript:void(0)" class="btn btn-sm btn-info edit-modal" data-edit-url="{{ route('admin.plan.edit', $plan->id) }}"><x-icon name="edit" height="20" />{{ __('Edit') }}</a>
                                    <a href="javascript:void(0)" class="btn btn-sm btn-danger delete" data-url="{{ route('admin.plan.destroy', $plan->id) }}"><x-icon name="delete-3" height="20" />{{ __('Delete') }}</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>


    @include('backend.plan.partial._new_plan_modal')

    @include('backend.plan.partial._edit_plan_modal')


@endsection
@push('script')
    <script>
        $(document).ready(function() {
            // Cache selectors and variables
            let featureList = $('#feature-list-default');
            const newPlanForm = $('#new-plan-form');
            const newPlanModal = $('#new-plan-modal');

            // Function to add feature input dynamically
            function addFeatureInput() {
                const featureInput = `
            <div class="input-group mb-2 feature-input">
                <input type="text" class="form-control" name="features[]" placeholder="Enter feature" required>
                <button class="btn btn-danger remove-feature" type="button">
                    <i class="fa-solid fa-trash"></i>
                </button>
            </div>`;
                featureList.append(featureInput);
            }

            // Handle 'create plan' button click
            $('.create-plan').on('click', function() {
                newPlanForm[0].reset();  // Reset form
                featureList = $('#feature-list-default');  // Reset feature list to default
                newPlanModal.modal('show');  // Show modal
            });

            // Handle 'edit modal' button click
            $('.edit-modal').on('click', function() {
                $('#edit-plan-modal').on('shown.bs.modal', function () {
                    featureList = $('#feature-list-en');  // Set feature list for editing
                });
            });

            // Switch feature list based on selected language tab
            $(document).on('click', '.lang-tab', function () {
                const lang = $(this).data('lang');  // Get selected language
                featureList = $('#feature-list-' + lang);  // Set feature list based on language
            });

            // Delegate event to add feature input dynamically
            $(document).on('click', '.add-feature', function() {
                addFeatureInput();  // Call function to add feature input
            });

            // Delegate event to remove dynamically added feature inputs
            $(document).on('click', '.remove-feature', function() {
                $(this).closest('.feature-input').remove();  // Remove the specific feature input
            });

             editFormByModal('edit-plan-modal', 'edit-plan-data', true);

        });
    </script>
@endpush
