@extends('backend.layouts.app')
@section('title', __('Payment Gateways'))
@section('content')
    <div class="py-4">
        <div class="d-flex justify-content-between w-100 flex-wrap">
            <div class="mb-3 mb-lg-0">
                <h1 class="h4">{{  __('Payment Gateways') }}</h1>
            </div>
        </div>
    </div>
    <div class="card border-0 mb-4">

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Logo') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Supported Currencies') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($paymentGateways as $paymentGateway)
                        <tr class="align-middle">
                            <td class="text-nowrap">
                                <img src="{{ asset($paymentGateway->logo) }}" alt="{{ $paymentGateway->name }} Logo" class="img-fluid table-logo">
                            </td>
                            <td class="fw-bold text-start">
                                {{ $paymentGateway->name }}
                            </td>
                            <td class="text-start">
                                <div class="avatars-stack d-flex flex-wrap gap-0">
                                    @foreach(array_slice($paymentGateway->currencies, 0, 4) as $currency)
                                        <span class="badge bg-info">{{ strtoupper($currency) }}</span>
                                    @endforeach
                                    @if(count($paymentGateway->currencies) > 4)
                                        <span class="badge bg-danger">+{{ count($paymentGateway->currencies) - 3 }}</span>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-{{ $paymentGateway->status ? 'success' : 'danger' }}">{{ strtoupper($paymentGateway->status ? __('Active') : __('Inactive')) }}</span>
                            </td>
                            <td>
                                <div class="d-inline-flex">
                                    <button class="edit-modal btn btn-gray-700 btn-sm d-flex align-items-center"
                                            data-bs-toggle="tooltip" title="{{ __('Manage Gateway Credentials and Others') }}"
                                            data-edit-url="{{ route('admin.payment.gateway.edit',$paymentGateway->id) }}">
                                        <x-icon name="manage" height="20" class="me-2"/> {{ __('Manage') }}
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>


    {{-- Edit Payment Gateway Modal --}}
    @include('backend.payment_gateway.partial._edit_payment_gateway_modal')
@endsection
@push('script')
    <script>
        $(document).ready(function () {
            editFormByModal('edit-payment-gateway-modal', 'edit-payment-gateway-append');
        });
    </script>
@endpush
