<form method="POST" action="{{ route('admin.payment.gateway.update', ['gateway' => $paymentGateway->id]) }}" enctype="multipart/form-data">
    @method('PUT')
    @csrf
    <div class="row">
        <div class="col-md-12 mb-3">
            <div>
                <label class="form-label" for="name">{{ __('Gateway Name') }}</label>
                <input class="form-control" name="name" id="name" value="{{ $paymentGateway->name }}" type="text"
                       required>
            </div>
        </div>
    </div>

    <div class="row">
        @foreach($paymentGateway->credentials as $key => $value)
        <div class="col-md-12 mb-3">
            <div>
                <label class="form-label" for="{{ $key}}">{{ ucwords(str_replace( '_', ' ', $key)) }}</label>
                <input class="form-control" name="credentials[{{ $key }}]" id="{{ $key}}" value="{{ $value }}"
                       type="text" required>
            </div>
        </div>
        @endforeach
    </div>

    <div class="row">
        <div class="col-md-6 mb-3 mt-2">
            <div class="card">
                <div class="form-check form-switch card-body p-2 rounded d-flex align-items-center">
                    <label class="form-check-label mb-0 flex-grow-1" for="status">{{ __('Status') }}</label>
                    <input class="form-check-input coevs-switch flex-shrink-0 ms-2" type="checkbox" role="switch"
                           name="status" @checked($paymentGateway->status) value="1" id="status">
                </div>
            </div>
        </div>
    </div>


    <div class="mt-3">
        <button class="btn btn-info" type="submit">
            <x-icon name="check" height="20"/>
            {{ __('Update Now') }}</button>
    </div>
</form>
