<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <h5 class="card-title">{{ $task->name }}</h5>
            <p class="card-text">{{ $task->description }}</p>
        </div>
        <div class="d-flex align-items-center">
            <div class="progress-wrapper">
                <div class="progress-info">
                    <div class="progress-label me-1">
                        <span class="text-primary">{{ __('Working Progress') }}</span>
                    </div>
                    <div class="progress-percentage">
                        <span>{{ $task->progress }}%</span>
                    </div>
                </div>
                <div class="progress">
                    <div class="progress-bar bg-primary" role="progressbar" style="width: {{ $task->progress }}%;" aria-valuenow="{{ $task->progress }}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-12 col-md-6">
                <div class="d-flex mb-2">
                    <strong class="me-2">{{ __('Priority') }}:</strong>
                    <span class="badge  bg-{{ $taskPriority[$task->priority] }}">{{ title($task->priority) }}</span>
                </div>
                @if($task->attachment)
                    <div class="d-flex mb-2">
                        <strong class="me-2">{{ __('Attachment/File') }}:</strong>
                        <a href="{{ route('admin.order.task-file', $task->id) }}" class="btn btn-sm btn-primary rounded">
                            <i class="fas fa-download me-2"></i> {{ __('Download') }}
                        </a>
                    </div>
                @endif
                <div class="d-flex mb-2">
                    <strong class="me-2">{{ __('Status') }}:</strong>
                    <span class="badge  bg-{{ $taskStatus[$task->status] }}">{{ title($task->status) }}</span>
                </div>
            </div>
            <div class="col-12 col-md-6">
                <div class="d-flex mb-2">
                    <strong class="me-2">{{ __('Due Date') }}:</strong> {{ $task->due_date->format('M d, Y') }}
                </div>
                <div class="d-flex mb-2">
                    <strong class="me-2">{{ __('Created Date') }}:</strong> {{ $task->created_at->format('M d, Y') }}
                </div>
            </div>
        </div>
    </div>
</div>
