<div class="col-xl-8">
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <div class="row">

                @foreach($statuses as $status => $data)
                    <div class="col">
                        <div class="d-flex justify-content-between align-items-center mb-3 rounded border-bottom border-3 {{ $data['border'] }}">
                            <h2 class="text-uppercase h6 mx-3">{{ $data['label'] }}</h2>
                            @if($status === 'todo')
                                <button type="button" class="btn btn-sm btn-info p-1" data-bs-toggle="modal" data-bs-target="#new-task-modal">
                                    <i class="fas fa-plus"></i> {{ __('Add New') }}
                                </button>
                            @endif
                        </div>
                        <div class="sortable-column" id="{{ $data['column_id'] }}">
                            @foreach($data['tasks'] as $task)
                                <div class="card mb-3" draggable="true">
                                    <input type="hidden" name="tasks[{{ $task->id }}][status]" value="{{ $order->status }}">
                                    <div class="card-body" >
                                        <div class="d-flex justify-content-between align-items-start mb-1">
                                            <span class="badge badge-sm bg-{{ $taskPriority[$task->priority] }}">{{ title($task->priority) }}</span>
                                            <a href="javascript:void(0)" class="show-modal" data-show-url="{{ route('admin.order.task.show', $task->id) }}"><i class="fas fa-eye text-muted ms-2"></i></a>
                                        </div>
                                        <p class="mb-1">{{ $task->name }}</p>
                                        <div class="text-muted">
                                            <span><i class="fas fa-clock"></i> {{ $task->due_date->format('d M') }}</span>
                                            <a href="javascript:void(0)" class="edit-modal" data-edit-url="{{ route('admin.order.task.edit', $task->id) }}"><i class="fas fa-edit text-muted ms-2"></i> </a>
                                            <a href="javascript:void(0)" class="delete" data-url="{{ route('admin.order.task.destroy', $task->id) }}"><i class="fas fa-trash text-muted text-danger ms-2"></i></a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
