<form action="{{ route('admin.order.task.update',$task->id) }}" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    <input type="hidden" name="id" id="task-id" value="{{ $task->id }}">
    <div class="mb-3">
        <label class="form-label" for="task-name">{{ __('Name') }}</label>
        <input type="text" class="form-control" id="task-name" name="name" value="{{ old('name', $task->name) }}" required>
    </div>
    <div class="mb-3">
        <label class="form-label" for="task-description">{{ __('Description') }}</label>
        <textarea class="form-control" id="task-description" name="description" rows="3" required>{{ old('description', $task->description) }}</textarea>
    </div>
    <div class="mb-3">
        <label class="form-label" for="task-file">{{ __('Attach File') }}</label>
        <input type="file" class="form-control" id="task-file" name="attachment">
    </div>
    <div class="mb-3">
        <label class="form-label" for="task-priority">{{ __('Priority') }}</label>
        <select class="form-select" id="task-priority" name="priority" required>
            @foreach(\App\Constants\TaskPriority::TYPE as $key => $value)
                <option value="{{ $value }}" {{ old('priority', $task->priority) == $value ? 'selected' : '' }}>{{ title($value) }}</option>
            @endforeach
        </select>
    </div>
    <div class="mb-3">

        <label class="form-label" for="task-due-date">{{ __('Due Date') }}</label>
        <input type="date" class="form-control" id="task-due-date" name="due_date" value="{{ old('due_date', $task->due_date->format('Y-m-d')) }}" required>
    </div>
    <div class="mb-3">
        <label class="form-label" for="task-due-date">{{ __('Progress') }}</label>
        <input type="range" name="progress" class="form-range" value="{{ old('progress', $task->progress) }}" id="customRange1">
    </div>
    <div class="mb-3">
        <label class="form-label" for="task-status">{{ __('Status') }}</label>
        <select class="form-select" id="task-status" name="status" required>
            @foreach(\App\Constants\TaskStatus::STATUS as $key => $value)
                <option value="{{ $value }}" {{ old('status', $task->status) == $value ? 'selected' : '' }}>{{ title($value) }}</option>
            @endforeach
        </select>
    </div>
    <div class="d-flex justify-content-between">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"> <x-icon name="close" height="20"/> {{ __('Cancel') }}</button>
        <button type="submit" class="btn btn-info"> <x-icon name="add" height="20"/> {{ __('Update') }}</button>
    </div>
</form>
