<div class="modal fade" id="new-task-modal" tabindex="-1" aria-labelledby="newTaskModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light">
                <h5 class="modal-title" id="newTaskModalLabel">{{ __('New Task') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('admin.order.task.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="order_id" value="{{ $order->id }}">
                    <div class="mb-3">
                        <label class="form-label" for="task-name">{{ __('Name') }}</label>
                        <input type="text" class="form-control" id="task-name" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="task-description">{{ __('Description') }}</label>
                        <textarea class="form-control" id="task-description" name="description" rows="3" required></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="task-file">{{ __('Attach File') }}</label>
                        <input type="file" class="form-control" id="task-file" name="attachment">
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="task-priority">{{ __('Priority') }}</label>
                        <select class="form-select" id="task-priority" name="priority" required>
                            @foreach(\App\Constants\TaskPriority::TYPE as $key => $value)
                                <option value="{{ $value }}">{{ title($value) }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="task-due-date">{{ __('Due Date') }}</label>
                        <input type="date" class="form-control" id="task-due-date" name="due_date" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="task-status">{{ __('Status') }}</label>
                        <select class="form-select" id="task-status" name="status" required>
                            @foreach(\App\Constants\TaskStatus::STATUS as $key => $value)
                                <option value="{{ $value }}">{{ title($value) }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"> <x-icon name="close" height="20"/> {{ __('Cancel') }}</button>
                        <button type="submit" class="btn btn-info"> <x-icon name="add" height="20"/> {{ __('Create') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
